/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGatewayAssociation> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::directConnectGatewayId)).setter(DirectConnectGatewayAssociation.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayId)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayRegion)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayRegion").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayOwnerAccount)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayOwnerAccount").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::associationStateAsString)).setter(DirectConnectGatewayAssociation.setter(Builder::associationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationState").build()}).build();
    private static final SdkField<String> STATE_CHANGE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::stateChangeError)).setter(DirectConnectGatewayAssociation.setter(Builder::stateChangeError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, VIRTUAL_GATEWAY_ID_FIELD, VIRTUAL_GATEWAY_REGION_FIELD, VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD, ASSOCIATION_STATE_FIELD, STATE_CHANGE_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directConnectGatewayId;
    private final String virtualGatewayId;
    private final String virtualGatewayRegion;
    private final String virtualGatewayOwnerAccount;
    private final String associationState;
    private final String stateChangeError;

    private DirectConnectGatewayAssociation(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.virtualGatewayRegion = builder.virtualGatewayRegion;
        this.virtualGatewayOwnerAccount = builder.virtualGatewayOwnerAccount;
        this.associationState = builder.associationState;
        this.stateChangeError = builder.stateChangeError;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public String virtualGatewayRegion() {
        return this.virtualGatewayRegion;
    }

    public String virtualGatewayOwnerAccount() {
        return this.virtualGatewayOwnerAccount;
    }

    public DirectConnectGatewayAssociationState associationState() {
        return DirectConnectGatewayAssociationState.fromValue(this.associationState);
    }

    public String associationStateAsString() {
        return this.associationState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociation)) {
            return false;
        }
        DirectConnectGatewayAssociation other = (DirectConnectGatewayAssociation)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.virtualGatewayRegion(), other.virtualGatewayRegion()) && Objects.equals(this.virtualGatewayOwnerAccount(), other.virtualGatewayOwnerAccount()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGatewayAssociation").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("VirtualGatewayRegion", (Object)this.virtualGatewayRegion()).add("VirtualGatewayOwnerAccount", (Object)this.virtualGatewayOwnerAccount()).add("AssociationState", (Object)this.associationStateAsString()).add("StateChangeError", (Object)this.stateChangeError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
            case "virtualGatewayRegion": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayRegion()));
            }
            case "virtualGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayOwnerAccount()));
            }
            case "associationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "stateChangeError": {
                return Optional.ofNullable(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAssociation, T> g) {
        return obj -> g.apply((DirectConnectGatewayAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualGatewayId;
        private String virtualGatewayRegion;
        private String virtualGatewayOwnerAccount;
        private String associationState;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociation model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualGatewayId(model.virtualGatewayId);
            this.virtualGatewayRegion(model.virtualGatewayRegion);
            this.virtualGatewayOwnerAccount(model.virtualGatewayOwnerAccount);
            this.associationState(model.associationState);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final String getVirtualGatewayRegion() {
            return this.virtualGatewayRegion;
        }

        @Override
        public final Builder virtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
            return this;
        }

        public final void setVirtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
        }

        public final String getVirtualGatewayOwnerAccount() {
            return this.virtualGatewayOwnerAccount;
        }

        @Override
        public final Builder virtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
            return this;
        }

        public final void setVirtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(DirectConnectGatewayAssociationState associationState) {
            this.associationState(associationState.toString());
            return this;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public DirectConnectGatewayAssociation build() {
            return new DirectConnectGatewayAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGatewayAssociation> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder virtualGatewayRegion(String var1);

        public Builder virtualGatewayOwnerAccount(String var1);

        public Builder associationState(String var1);

        public Builder associationState(DirectConnectGatewayAssociationState var1);

        public Builder stateChangeError(String var1);
    }
}

