/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Location;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocationMarshaller {
    private static final MarshallingInfo<String> LOCATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locationCode").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locationName").isBinary(false).build();
    private static final LocationMarshaller INSTANCE = new LocationMarshaller();

    private LocationMarshaller() {
    }

    public static LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Location location, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)location, (String)"location");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)location.locationCode(), LOCATIONCODE_BINDING);
            protocolMarshaller.marshall((Object)location.locationName(), LOCATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

