/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInterconnectRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateInterconnectRequest> {
    private final String interconnectName;
    private final String bandwidth;
    private final String location;
    private final String lagId;

    private CreateInterconnectRequest(BuilderImpl builder) {
        super(builder);
        this.interconnectName = builder.interconnectName;
        this.bandwidth = builder.bandwidth;
        this.location = builder.location;
        this.lagId = builder.lagId;
    }

    public String interconnectName() {
        return this.interconnectName;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public String location() {
        return this.location;
    }

    public String lagId() {
        return this.lagId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInterconnectRequest)) {
            return false;
        }
        CreateInterconnectRequest other = (CreateInterconnectRequest)((Object)obj);
        return Objects.equals(this.interconnectName(), other.interconnectName()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.lagId(), other.lagId());
    }

    public String toString() {
        return ToString.builder((String)"CreateInterconnectRequest").add("InterconnectName", (Object)this.interconnectName()).add("Bandwidth", (Object)this.bandwidth()).add("Location", (Object)this.location()).add("LagId", (Object)this.lagId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectName": {
                return Optional.of(clazz.cast(this.interconnectName()));
            }
            case "bandwidth": {
                return Optional.of(clazz.cast(this.bandwidth()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String interconnectName;
        private String bandwidth;
        private String location;
        private String lagId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInterconnectRequest model) {
            this.interconnectName(model.interconnectName);
            this.bandwidth(model.bandwidth);
            this.location(model.location);
            this.lagId(model.lagId);
        }

        public final String getInterconnectName() {
            return this.interconnectName;
        }

        @Override
        public final Builder interconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public final void setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInterconnectRequest build() {
            return new CreateInterconnectRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreateInterconnectRequest> {
        public Builder interconnectName(String var1);

        public Builder bandwidth(String var1);

        public Builder location(String var1);

        public Builder lagId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

