/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewBGPPeer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBGPPeerRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateBGPPeerRequest> {
    private final String virtualInterfaceId;
    private final NewBGPPeer newBGPPeer;

    private CreateBGPPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.newBGPPeer = builder.newBGPPeer;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public NewBGPPeer newBGPPeer() {
        return this.newBGPPeer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newBGPPeer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBGPPeerRequest)) {
            return false;
        }
        CreateBGPPeerRequest other = (CreateBGPPeerRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.newBGPPeer(), other.newBGPPeer());
    }

    public String toString() {
        return ToString.builder((String)"CreateBGPPeerRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("NewBGPPeer", (Object)this.newBGPPeer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "newBGPPeer": {
                return Optional.of(clazz.cast(this.newBGPPeer()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private NewBGPPeer newBGPPeer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBGPPeerRequest model) {
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.newBGPPeer(model.newBGPPeer);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final NewBGPPeer.Builder getNewBGPPeer() {
            return this.newBGPPeer != null ? this.newBGPPeer.toBuilder() : null;
        }

        @Override
        public final Builder newBGPPeer(NewBGPPeer newBGPPeer) {
            this.newBGPPeer = newBGPPeer;
            return this;
        }

        public final void setNewBGPPeer(NewBGPPeer.BuilderImpl newBGPPeer) {
            this.newBGPPeer = newBGPPeer != null ? newBGPPeer.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateBGPPeerRequest build() {
            return new CreateBGPPeerRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreateBGPPeerRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder newBGPPeer(NewBGPPeer var1);

        default public Builder newBGPPeer(Consumer<NewBGPPeer.Builder> newBGPPeer) {
            return this.newBGPPeer((NewBGPPeer)((NewBGPPeer.Builder)NewBGPPeer.builder().apply(newBGPPeer)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

