/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocatePublicVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocatePublicVirtualInterfaceRequest> {
    private final String connectionId;
    private final String ownerAccount;
    private final NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

    private AllocatePublicVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPublicVirtualInterfaceAllocation = builder.newPublicVirtualInterfaceAllocation;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation() {
        return this.newPublicVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPublicVirtualInterfaceAllocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePublicVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePublicVirtualInterfaceRequest other = (AllocatePublicVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.newPublicVirtualInterfaceAllocation(), other.newPublicVirtualInterfaceAllocation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.newPublicVirtualInterfaceAllocation() != null) {
            sb.append("NewPublicVirtualInterfaceAllocation: ").append(this.newPublicVirtualInterfaceAllocation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "newPublicVirtualInterfaceAllocation": {
                return Optional.of(clazz.cast(this.newPublicVirtualInterfaceAllocation()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePublicVirtualInterfaceRequest model) {
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.newPublicVirtualInterfaceAllocation(model.newPublicVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final NewPublicVirtualInterfaceAllocation.Builder getNewPublicVirtualInterfaceAllocation() {
            return this.newPublicVirtualInterfaceAllocation != null ? this.newPublicVirtualInterfaceAllocation.toBuilder() : null;
        }

        @Override
        public final Builder newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation;
            return this;
        }

        public final void setNewPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation.BuilderImpl newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation != null ? newPublicVirtualInterfaceAllocation.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocatePublicVirtualInterfaceRequest build() {
            return new AllocatePublicVirtualInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, AllocatePublicVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation var1);

        default public Builder newPublicVirtualInterfaceAllocation(Consumer<NewPublicVirtualInterfaceAllocation.Builder> newPublicVirtualInterfaceAllocation) {
            return this.newPublicVirtualInterfaceAllocation((NewPublicVirtualInterfaceAllocation)((NewPublicVirtualInterfaceAllocation.Builder)NewPublicVirtualInterfaceAllocation.builder().apply(newPublicVirtualInterfaceAllocation)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

