/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateLagRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateLagRequest> {
    private final String lagId;
    private final String lagName;
    private final Integer minimumLinks;

    private UpdateLagRequest(BuilderImpl builder) {
        this.lagId = builder.lagId;
        this.lagName = builder.lagName;
        this.minimumLinks = builder.minimumLinks;
    }

    public String lagId() {
        return this.lagId;
    }

    public String lagName() {
        return this.lagName;
    }

    public Integer minimumLinks() {
        return this.minimumLinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lagId() == null ? 0 : this.lagId().hashCode());
        hashCode = 31 * hashCode + (this.lagName() == null ? 0 : this.lagName().hashCode());
        hashCode = 31 * hashCode + (this.minimumLinks() == null ? 0 : this.minimumLinks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLagRequest)) {
            return false;
        }
        UpdateLagRequest other = (UpdateLagRequest)((Object)obj);
        if (other.lagId() == null ^ this.lagId() == null) {
            return false;
        }
        if (other.lagId() != null && !other.lagId().equals(this.lagId())) {
            return false;
        }
        if (other.lagName() == null ^ this.lagName() == null) {
            return false;
        }
        if (other.lagName() != null && !other.lagName().equals(this.lagName())) {
            return false;
        }
        if (other.minimumLinks() == null ^ this.minimumLinks() == null) {
            return false;
        }
        return other.minimumLinks() == null || other.minimumLinks().equals(this.minimumLinks());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lagId() != null) {
            sb.append("LagId: ").append(this.lagId()).append(",");
        }
        if (this.lagName() != null) {
            sb.append("LagName: ").append(this.lagName()).append(",");
        }
        if (this.minimumLinks() != null) {
            sb.append("MinimumLinks: ").append(this.minimumLinks()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
            case "lagName": {
                return Optional.of(clazz.cast(this.lagName()));
            }
            case "minimumLinks": {
                return Optional.of(clazz.cast(this.minimumLinks()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String lagId;
        private String lagName;
        private Integer minimumLinks;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLagRequest model) {
            this.lagId(model.lagId);
            this.lagName(model.lagName);
            this.minimumLinks(model.minimumLinks);
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getLagName() {
            return this.lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final Integer getMinimumLinks() {
            return this.minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        public UpdateLagRequest build() {
            return new UpdateLagRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateLagRequest> {
        public Builder lagId(String var1);

        public Builder lagName(String var1);

        public Builder minimumLinks(Integer var1);
    }
}

