/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.transform.LocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Location
implements StructuredPojo,
ToCopyableBuilder<Builder, Location> {
    private final String locationCode;
    private final String locationName;

    private Location(BuilderImpl builder) {
        this.locationCode = builder.locationCode;
        this.locationName = builder.locationName;
    }

    public String locationCode() {
        return this.locationCode;
    }

    public String locationName() {
        return this.locationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.locationCode() == null ? 0 : this.locationCode().hashCode());
        hashCode = 31 * hashCode + (this.locationName() == null ? 0 : this.locationName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (other.locationCode() == null ^ this.locationCode() == null) {
            return false;
        }
        if (other.locationCode() != null && !other.locationCode().equals(this.locationCode())) {
            return false;
        }
        if (other.locationName() == null ^ this.locationName() == null) {
            return false;
        }
        return other.locationName() == null || other.locationName().equals(this.locationName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.locationCode() != null) {
            sb.append("LocationCode: ").append(this.locationCode()).append(",");
        }
        if (this.locationName() != null) {
            sb.append("LocationName: ").append(this.locationName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationCode": {
                return Optional.of(clazz.cast(this.locationCode()));
            }
            case "locationName": {
                return Optional.of(clazz.cast(this.locationName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationCode;
        private String locationName;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.locationCode(model.locationCode);
            this.locationName(model.locationName);
        }

        public final String getLocationCode() {
            return this.locationCode;
        }

        @Override
        public final Builder locationCode(String locationCode) {
            this.locationCode = locationCode;
            return this;
        }

        public final void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        public final String getLocationName() {
            return this.locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        public Location build() {
            return new Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Location> {
        public Builder locationCode(String var1);

        public Builder locationName(String var1);
    }
}

