/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisassociateConnectionFromLagRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisassociateConnectionFromLagRequest> {
    private final String connectionId;
    private final String lagId;

    private DisassociateConnectionFromLagRequest(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.lagId = builder.lagId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String lagId() {
        return this.lagId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionId() == null ? 0 : this.connectionId().hashCode());
        hashCode = 31 * hashCode + (this.lagId() == null ? 0 : this.lagId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateConnectionFromLagRequest)) {
            return false;
        }
        DisassociateConnectionFromLagRequest other = (DisassociateConnectionFromLagRequest)((Object)obj);
        if (other.connectionId() == null ^ this.connectionId() == null) {
            return false;
        }
        if (other.connectionId() != null && !other.connectionId().equals(this.connectionId())) {
            return false;
        }
        if (other.lagId() == null ^ this.lagId() == null) {
            return false;
        }
        return other.lagId() == null || other.lagId().equals(this.lagId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.lagId() != null) {
            sb.append("LagId: ").append(this.lagId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private String lagId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateConnectionFromLagRequest model) {
            this.connectionId(model.connectionId);
            this.lagId(model.lagId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public DisassociateConnectionFromLagRequest build() {
            return new DisassociateConnectionFromLagRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisassociateConnectionFromLagRequest> {
        public Builder connectionId(String var1);

        public Builder lagId(String var1);
    }
}

