/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVirtualInterfacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVirtualInterfacesRequest> {
    private final String connectionId;
    private final String virtualInterfaceId;

    private DescribeVirtualInterfacesRequest(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionId() == null ? 0 : this.connectionId().hashCode());
        hashCode = 31 * hashCode + (this.virtualInterfaceId() == null ? 0 : this.virtualInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualInterfacesRequest)) {
            return false;
        }
        DescribeVirtualInterfacesRequest other = (DescribeVirtualInterfacesRequest)((Object)obj);
        if (other.connectionId() == null ^ this.connectionId() == null) {
            return false;
        }
        if (other.connectionId() != null && !other.connectionId().equals(this.connectionId())) {
            return false;
        }
        if (other.virtualInterfaceId() == null ^ this.virtualInterfaceId() == null) {
            return false;
        }
        return other.virtualInterfaceId() == null || other.virtualInterfaceId().equals(this.virtualInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.virtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.virtualInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private String virtualInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualInterfacesRequest model) {
            this.connectionId(model.connectionId);
            this.virtualInterfaceId(model.virtualInterfaceId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public DescribeVirtualInterfacesRequest build() {
            return new DescribeVirtualInterfacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVirtualInterfacesRequest> {
        public Builder connectionId(String var1);

        public Builder virtualInterfaceId(String var1);
    }
}

