/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInterconnectLoaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
    private final String interconnectId;
    private final String providerName;
    private final String loaContentType;

    private DescribeInterconnectLoaRequest(BuilderImpl builder) {
        this.interconnectId = builder.interconnectId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String providerName() {
        return this.providerName;
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeString() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.interconnectId() == null ? 0 : this.interconnectId().hashCode());
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.loaContentTypeString() == null ? 0 : this.loaContentTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectLoaRequest)) {
            return false;
        }
        DescribeInterconnectLoaRequest other = (DescribeInterconnectLoaRequest)((Object)obj);
        if (other.interconnectId() == null ^ this.interconnectId() == null) {
            return false;
        }
        if (other.interconnectId() != null && !other.interconnectId().equals(this.interconnectId())) {
            return false;
        }
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.loaContentTypeString() == null ^ this.loaContentTypeString() == null) {
            return false;
        }
        return other.loaContentTypeString() == null || other.loaContentTypeString().equals(this.loaContentTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.interconnectId() != null) {
            sb.append("InterconnectId: ").append(this.interconnectId()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.loaContentTypeString() != null) {
            sb.append("LoaContentType: ").append(this.loaContentTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.of(clazz.cast(this.interconnectId()));
            }
            case "providerName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
            case "loaContentType": {
                return Optional.of(clazz.cast(this.loaContentTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String interconnectId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectLoaRequest model) {
            this.interconnectId(model.interconnectId);
            this.providerName(model.providerName);
            this.loaContentType(model.loaContentType);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        public DescribeInterconnectLoaRequest build() {
            return new DescribeInterconnectLoaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
        public Builder interconnectId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

