/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteBGPPeerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteBGPPeerRequest> {
    private final String virtualInterfaceId;
    private final Integer asn;
    private final String customerAddress;

    private DeleteBGPPeerRequest(BuilderImpl builder) {
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.asn = builder.asn;
        this.customerAddress = builder.customerAddress;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public Integer asn() {
        return this.asn;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.virtualInterfaceId() == null ? 0 : this.virtualInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.asn() == null ? 0 : this.asn().hashCode());
        hashCode = 31 * hashCode + (this.customerAddress() == null ? 0 : this.customerAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBGPPeerRequest)) {
            return false;
        }
        DeleteBGPPeerRequest other = (DeleteBGPPeerRequest)((Object)obj);
        if (other.virtualInterfaceId() == null ^ this.virtualInterfaceId() == null) {
            return false;
        }
        if (other.virtualInterfaceId() != null && !other.virtualInterfaceId().equals(this.virtualInterfaceId())) {
            return false;
        }
        if (other.asn() == null ^ this.asn() == null) {
            return false;
        }
        if (other.asn() != null && !other.asn().equals(this.asn())) {
            return false;
        }
        if (other.customerAddress() == null ^ this.customerAddress() == null) {
            return false;
        }
        return other.customerAddress() == null || other.customerAddress().equals(this.customerAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.virtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.virtualInterfaceId()).append(",");
        }
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "asn": {
                return Optional.of(clazz.cast(this.asn()));
            }
            case "customerAddress": {
                return Optional.of(clazz.cast(this.customerAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private Integer asn;
        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBGPPeerRequest model) {
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.asn(model.asn);
            this.customerAddress(model.customerAddress);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public DeleteBGPPeerRequest build() {
            return new DeleteBGPPeerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteBGPPeerRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder asn(Integer var1);

        public Builder customerAddress(String var1);
    }
}

