/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeer;
import software.amazon.awssdk.services.directconnect.model.BGPPeerListCopier;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePrivateVirtualInterfaceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreatePrivateVirtualInterfaceResponse> {
    private final String ownerAccount;
    private final String virtualInterfaceId;
    private final String location;
    private final String connectionId;
    private final String virtualInterfaceType;
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final String virtualInterfaceState;
    private final String customerRouterConfig;
    private final String virtualGatewayId;
    private final List<RouteFilterPrefix> routeFilterPrefixes;
    private final List<BGPPeer> bgpPeers;

    private CreatePrivateVirtualInterfaceResponse(BuilderImpl builder) {
        this.ownerAccount = builder.ownerAccount;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.location = builder.location;
        this.connectionId = builder.connectionId;
        this.virtualInterfaceType = builder.virtualInterfaceType;
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.virtualInterfaceState = builder.virtualInterfaceState;
        this.customerRouterConfig = builder.customerRouterConfig;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.bgpPeers = builder.bgpPeers;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public String location() {
        return this.location;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String virtualInterfaceType() {
        return this.virtualInterfaceType;
    }

    public String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyString() {
        return this.addressFamily;
    }

    public VirtualInterfaceState virtualInterfaceState() {
        return VirtualInterfaceState.fromValue(this.virtualInterfaceState);
    }

    public String virtualInterfaceStateString() {
        return this.virtualInterfaceState;
    }

    public String customerRouterConfig() {
        return this.customerRouterConfig;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public List<RouteFilterPrefix> routeFilterPrefixes() {
        return this.routeFilterPrefixes;
    }

    public List<BGPPeer> bgpPeers() {
        return this.bgpPeers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.virtualInterfaceId() == null ? 0 : this.virtualInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.connectionId() == null ? 0 : this.connectionId().hashCode());
        hashCode = 31 * hashCode + (this.virtualInterfaceType() == null ? 0 : this.virtualInterfaceType().hashCode());
        hashCode = 31 * hashCode + (this.virtualInterfaceName() == null ? 0 : this.virtualInterfaceName().hashCode());
        hashCode = 31 * hashCode + (this.vlan() == null ? 0 : this.vlan().hashCode());
        hashCode = 31 * hashCode + (this.asn() == null ? 0 : this.asn().hashCode());
        hashCode = 31 * hashCode + (this.authKey() == null ? 0 : this.authKey().hashCode());
        hashCode = 31 * hashCode + (this.amazonAddress() == null ? 0 : this.amazonAddress().hashCode());
        hashCode = 31 * hashCode + (this.customerAddress() == null ? 0 : this.customerAddress().hashCode());
        hashCode = 31 * hashCode + (this.addressFamilyString() == null ? 0 : this.addressFamilyString().hashCode());
        hashCode = 31 * hashCode + (this.virtualInterfaceStateString() == null ? 0 : this.virtualInterfaceStateString().hashCode());
        hashCode = 31 * hashCode + (this.customerRouterConfig() == null ? 0 : this.customerRouterConfig().hashCode());
        hashCode = 31 * hashCode + (this.virtualGatewayId() == null ? 0 : this.virtualGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.routeFilterPrefixes() == null ? 0 : this.routeFilterPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.bgpPeers() == null ? 0 : this.bgpPeers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateVirtualInterfaceResponse)) {
            return false;
        }
        CreatePrivateVirtualInterfaceResponse other = (CreatePrivateVirtualInterfaceResponse)((Object)obj);
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.virtualInterfaceId() == null ^ this.virtualInterfaceId() == null) {
            return false;
        }
        if (other.virtualInterfaceId() != null && !other.virtualInterfaceId().equals(this.virtualInterfaceId())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.connectionId() == null ^ this.connectionId() == null) {
            return false;
        }
        if (other.connectionId() != null && !other.connectionId().equals(this.connectionId())) {
            return false;
        }
        if (other.virtualInterfaceType() == null ^ this.virtualInterfaceType() == null) {
            return false;
        }
        if (other.virtualInterfaceType() != null && !other.virtualInterfaceType().equals(this.virtualInterfaceType())) {
            return false;
        }
        if (other.virtualInterfaceName() == null ^ this.virtualInterfaceName() == null) {
            return false;
        }
        if (other.virtualInterfaceName() != null && !other.virtualInterfaceName().equals(this.virtualInterfaceName())) {
            return false;
        }
        if (other.vlan() == null ^ this.vlan() == null) {
            return false;
        }
        if (other.vlan() != null && !other.vlan().equals(this.vlan())) {
            return false;
        }
        if (other.asn() == null ^ this.asn() == null) {
            return false;
        }
        if (other.asn() != null && !other.asn().equals(this.asn())) {
            return false;
        }
        if (other.authKey() == null ^ this.authKey() == null) {
            return false;
        }
        if (other.authKey() != null && !other.authKey().equals(this.authKey())) {
            return false;
        }
        if (other.amazonAddress() == null ^ this.amazonAddress() == null) {
            return false;
        }
        if (other.amazonAddress() != null && !other.amazonAddress().equals(this.amazonAddress())) {
            return false;
        }
        if (other.customerAddress() == null ^ this.customerAddress() == null) {
            return false;
        }
        if (other.customerAddress() != null && !other.customerAddress().equals(this.customerAddress())) {
            return false;
        }
        if (other.addressFamilyString() == null ^ this.addressFamilyString() == null) {
            return false;
        }
        if (other.addressFamilyString() != null && !other.addressFamilyString().equals(this.addressFamilyString())) {
            return false;
        }
        if (other.virtualInterfaceStateString() == null ^ this.virtualInterfaceStateString() == null) {
            return false;
        }
        if (other.virtualInterfaceStateString() != null && !other.virtualInterfaceStateString().equals(this.virtualInterfaceStateString())) {
            return false;
        }
        if (other.customerRouterConfig() == null ^ this.customerRouterConfig() == null) {
            return false;
        }
        if (other.customerRouterConfig() != null && !other.customerRouterConfig().equals(this.customerRouterConfig())) {
            return false;
        }
        if (other.virtualGatewayId() == null ^ this.virtualGatewayId() == null) {
            return false;
        }
        if (other.virtualGatewayId() != null && !other.virtualGatewayId().equals(this.virtualGatewayId())) {
            return false;
        }
        if (other.routeFilterPrefixes() == null ^ this.routeFilterPrefixes() == null) {
            return false;
        }
        if (other.routeFilterPrefixes() != null && !other.routeFilterPrefixes().equals(this.routeFilterPrefixes())) {
            return false;
        }
        if (other.bgpPeers() == null ^ this.bgpPeers() == null) {
            return false;
        }
        return other.bgpPeers() == null || other.bgpPeers().equals(this.bgpPeers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.virtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.virtualInterfaceId()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.virtualInterfaceType() != null) {
            sb.append("VirtualInterfaceType: ").append(this.virtualInterfaceType()).append(",");
        }
        if (this.virtualInterfaceName() != null) {
            sb.append("VirtualInterfaceName: ").append(this.virtualInterfaceName()).append(",");
        }
        if (this.vlan() != null) {
            sb.append("Vlan: ").append(this.vlan()).append(",");
        }
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.authKey() != null) {
            sb.append("AuthKey: ").append(this.authKey()).append(",");
        }
        if (this.amazonAddress() != null) {
            sb.append("AmazonAddress: ").append(this.amazonAddress()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        if (this.addressFamilyString() != null) {
            sb.append("AddressFamily: ").append(this.addressFamilyString()).append(",");
        }
        if (this.virtualInterfaceStateString() != null) {
            sb.append("VirtualInterfaceState: ").append(this.virtualInterfaceStateString()).append(",");
        }
        if (this.customerRouterConfig() != null) {
            sb.append("CustomerRouterConfig: ").append(this.customerRouterConfig()).append(",");
        }
        if (this.virtualGatewayId() != null) {
            sb.append("VirtualGatewayId: ").append(this.virtualGatewayId()).append(",");
        }
        if (this.routeFilterPrefixes() != null) {
            sb.append("RouteFilterPrefixes: ").append(this.routeFilterPrefixes()).append(",");
        }
        if (this.bgpPeers() != null) {
            sb.append("BgpPeers: ").append(this.bgpPeers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "virtualInterfaceType": {
                return Optional.of(clazz.cast(this.virtualInterfaceType()));
            }
            case "virtualInterfaceName": {
                return Optional.of(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.of(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.of(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.of(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.of(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.of(clazz.cast(this.customerAddress()));
            }
            case "addressFamily": {
                return Optional.of(clazz.cast(this.addressFamilyString()));
            }
            case "virtualInterfaceState": {
                return Optional.of(clazz.cast(this.virtualInterfaceStateString()));
            }
            case "customerRouterConfig": {
                return Optional.of(clazz.cast(this.customerRouterConfig()));
            }
            case "virtualGatewayId": {
                return Optional.of(clazz.cast(this.virtualGatewayId()));
            }
            case "routeFilterPrefixes": {
                return Optional.of(clazz.cast(this.routeFilterPrefixes()));
            }
            case "bgpPeers": {
                return Optional.of(clazz.cast(this.bgpPeers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String virtualInterfaceId;
        private String location;
        private String connectionId;
        private String virtualInterfaceType;
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private String virtualInterfaceState;
        private String customerRouterConfig;
        private String virtualGatewayId;
        private List<RouteFilterPrefix> routeFilterPrefixes;
        private List<BGPPeer> bgpPeers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateVirtualInterfaceResponse model) {
            this.ownerAccount(model.ownerAccount);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.location(model.location);
            this.connectionId(model.connectionId);
            this.virtualInterfaceType(model.virtualInterfaceType);
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.addressFamily(model.addressFamily);
            this.virtualInterfaceState(model.virtualInterfaceState);
            this.customerRouterConfig(model.customerRouterConfig);
            this.virtualGatewayId(model.virtualGatewayId);
            this.routeFilterPrefixes(model.routeFilterPrefixes);
            this.bgpPeers(model.bgpPeers);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getVirtualInterfaceType() {
            return this.virtualInterfaceType;
        }

        @Override
        public final Builder virtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
            return this;
        }

        public final void setVirtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getVirtualInterfaceState() {
            return this.virtualInterfaceState;
        }

        @Override
        public final Builder virtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
            return this;
        }

        @Override
        public final Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState) {
            this.virtualInterfaceState(virtualInterfaceState.toString());
            return this;
        }

        public final void setVirtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
        }

        public final String getCustomerRouterConfig() {
            return this.customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final Collection<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            return this.routeFilterPrefixes != null ? (Collection)this.routeFilterPrefixes.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        public final Collection<BGPPeer.Builder> getBgpPeers() {
            return this.bgpPeers != null ? (Collection)this.bgpPeers.stream().map(BGPPeer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bgpPeers(Collection<BGPPeer> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(BGPPeer ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final void setBgpPeers(Collection<BGPPeer.BuilderImpl> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copyFromBuilder(bgpPeers);
        }

        public CreatePrivateVirtualInterfaceResponse build() {
            return new CreatePrivateVirtualInterfaceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePrivateVirtualInterfaceResponse> {
        public Builder ownerAccount(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder location(String var1);

        public Builder connectionId(String var1);

        public Builder virtualInterfaceType(String var1);

        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder virtualInterfaceState(String var1);

        public Builder virtualInterfaceState(VirtualInterfaceState var1);

        public Builder customerRouterConfig(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder routeFilterPrefixes(Collection<RouteFilterPrefix> var1);

        public Builder routeFilterPrefixes(RouteFilterPrefix ... var1);

        public Builder bgpPeers(Collection<BGPPeer> var1);

        public Builder bgpPeers(BGPPeer ... var1);
    }
}

