/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateHostedConnectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateHostedConnectionRequest> {
    private final String connectionId;
    private final String parentConnectionId;

    private AssociateHostedConnectionRequest(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.parentConnectionId = builder.parentConnectionId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String parentConnectionId() {
        return this.parentConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionId() == null ? 0 : this.connectionId().hashCode());
        hashCode = 31 * hashCode + (this.parentConnectionId() == null ? 0 : this.parentConnectionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateHostedConnectionRequest)) {
            return false;
        }
        AssociateHostedConnectionRequest other = (AssociateHostedConnectionRequest)((Object)obj);
        if (other.connectionId() == null ^ this.connectionId() == null) {
            return false;
        }
        if (other.connectionId() != null && !other.connectionId().equals(this.connectionId())) {
            return false;
        }
        if (other.parentConnectionId() == null ^ this.parentConnectionId() == null) {
            return false;
        }
        return other.parentConnectionId() == null || other.parentConnectionId().equals(this.parentConnectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.parentConnectionId() != null) {
            sb.append("ParentConnectionId: ").append(this.parentConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "parentConnectionId": {
                return Optional.of(clazz.cast(this.parentConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private String parentConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateHostedConnectionRequest model) {
            this.connectionId(model.connectionId);
            this.parentConnectionId(model.parentConnectionId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getParentConnectionId() {
            return this.parentConnectionId;
        }

        @Override
        public final Builder parentConnectionId(String parentConnectionId) {
            this.parentConnectionId = parentConnectionId;
            return this;
        }

        public final void setParentConnectionId(String parentConnectionId) {
            this.parentConnectionId = parentConnectionId;
        }

        public AssociateHostedConnectionRequest build() {
            return new AssociateHostedConnectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateHostedConnectionRequest> {
        public Builder connectionId(String var1);

        public Builder parentConnectionId(String var1);
    }
}

