/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateConnectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateConnectionRequest> {
    private final String location;
    private final String bandwidth;
    private final String connectionName;
    private final String lagId;

    private CreateConnectionRequest(BuilderImpl builder) {
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.lagId = builder.lagId;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String lagId() {
        return this.lagId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.bandwidth() == null ? 0 : this.bandwidth().hashCode());
        hashCode = 31 * hashCode + (this.connectionName() == null ? 0 : this.connectionName().hashCode());
        hashCode = 31 * hashCode + (this.lagId() == null ? 0 : this.lagId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest)((Object)obj);
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.bandwidth() == null ^ this.bandwidth() == null) {
            return false;
        }
        if (other.bandwidth() != null && !other.bandwidth().equals(this.bandwidth())) {
            return false;
        }
        if (other.connectionName() == null ^ this.connectionName() == null) {
            return false;
        }
        if (other.connectionName() != null && !other.connectionName().equals(this.connectionName())) {
            return false;
        }
        if (other.lagId() == null ^ this.lagId() == null) {
            return false;
        }
        return other.lagId() == null || other.lagId().equals(this.lagId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.bandwidth() != null) {
            sb.append("Bandwidth: ").append(this.bandwidth()).append(",");
        }
        if (this.connectionName() != null) {
            sb.append("ConnectionName: ").append(this.connectionName()).append(",");
        }
        if (this.lagId() != null) {
            sb.append("LagId: ").append(this.lagId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String location;
        private String bandwidth;
        private String connectionName;
        private String lagId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            this.setLocation(model.location);
            this.setBandwidth(model.bandwidth);
            this.setConnectionName(model.connectionName);
            this.setLagId(model.lagId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateConnectionRequest> {
        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder connectionName(String var1);

        public Builder lagId(String var1);
    }
}

