/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.VirtualInterface;

@SdkInternalApi
public class VirtualInterfaceMarshaller {
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceId").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceType").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceState").build();
    private static final MarshallingInfo<String> CUSTOMERROUTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerRouterConfig").build();
    private static final MarshallingInfo<String> VIRTUALGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayId").build();
    private static final MarshallingInfo<List> ROUTEFILTERPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("routeFilterPrefixes").build();
    private static final MarshallingInfo<List> BGPPEERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeers").build();
    private static final VirtualInterfaceMarshaller INSTANCE = new VirtualInterfaceMarshaller();

    public static VirtualInterfaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VirtualInterface virtualInterface, ProtocolMarshaller protocolMarshaller) {
        if (virtualInterface == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)virtualInterface.ownerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceId(), VIRTUALINTERFACEID_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceType(), VIRTUALINTERFACETYPE_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.addressFamily(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceState(), VIRTUALINTERFACESTATE_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.customerRouterConfig(), CUSTOMERROUTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualGatewayId(), VIRTUALGATEWAYID_BINDING);
            protocolMarshaller.marshall(virtualInterface.routeFilterPrefixes(), ROUTEFILTERPREFIXES_BINDING);
            protocolMarshaller.marshall(virtualInterface.bgpPeers(), BGPPEERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

