/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Location;

@SdkInternalApi
public class LocationMarshaller {
    private static final MarshallingInfo<String> LOCATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locationCode").build();
    private static final MarshallingInfo<String> LOCATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locationName").build();
    private static final LocationMarshaller INSTANCE = new LocationMarshaller();

    public static LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Location location, ProtocolMarshaller protocolMarshaller) {
        if (location == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)location.locationCode(), LOCATIONCODE_BINDING);
            protocolMarshaller.marshall((Object)location.locationName(), LOCATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

