/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoaResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeLoaResponse> {
    private final SdkBytes loaContent;
    private final String loaContentType;

    private DescribeLoaResponse(BuilderImpl builder) {
        super(builder);
        this.loaContent = builder.loaContent;
        this.loaContentType = builder.loaContentType;
    }

    public SdkBytes loaContent() {
        return this.loaContent;
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeAsString() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaResponse)) {
            return false;
        }
        DescribeLoaResponse other = (DescribeLoaResponse)((Object)obj);
        return Objects.equals(this.loaContent(), other.loaContent()) && Objects.equals(this.loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoaResponse").add("LoaContent", (Object)this.loaContent()).add("LoaContentType", (Object)this.loaContentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loaContent": {
                return Optional.ofNullable(clazz.cast(this.loaContent()));
            }
            case "loaContentType": {
                return Optional.ofNullable(clazz.cast(this.loaContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private SdkBytes loaContent;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaResponse model) {
            super(model);
            this.loaContent(model.loaContent);
            this.loaContentType(model.loaContentType);
        }

        public final ByteBuffer getLoaContent() {
            return this.loaContent == null ? null : this.loaContent.asByteBuffer();
        }

        @Override
        public final Builder loaContent(SdkBytes loaContent) {
            this.loaContent = StandardMemberCopier.copy((SdkBytes)loaContent);
            return this;
        }

        public final void setLoaContent(ByteBuffer loaContent) {
            this.loaContent(loaContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)loaContent));
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        public DescribeLoaResponse build() {
            return new DescribeLoaResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeLoaResponse> {
        public Builder loaContent(SdkBytes var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

