/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionLoaRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeConnectionLoaRequest> {
    private final String connectionId;
    private final String providerName;
    private final String loaContentType;

    private DescribeConnectionLoaRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String providerName() {
        return this.providerName;
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeAsString() {
        return this.loaContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionLoaRequest)) {
            return false;
        }
        DescribeConnectionLoaRequest other = (DescribeConnectionLoaRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectionLoaRequest").add("ConnectionId", (Object)this.connectionId()).add("ProviderName", (Object)this.providerName()).add("LoaContentType", (Object)this.loaContentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "loaContentType": {
                return Optional.ofNullable(clazz.cast(this.loaContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionLoaRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.providerName(model.providerName);
            this.loaContentType(model.loaContentType);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectionLoaRequest build() {
            return new DescribeConnectionLoaRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeConnectionLoaRequest> {
        public Builder connectionId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

