/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateHostedConnectionRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AssociateHostedConnectionRequest> {
    private final String connectionId;
    private final String parentConnectionId;

    private AssociateHostedConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.parentConnectionId = builder.parentConnectionId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String parentConnectionId() {
        return this.parentConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateHostedConnectionRequest)) {
            return false;
        }
        AssociateHostedConnectionRequest other = (AssociateHostedConnectionRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.parentConnectionId(), other.parentConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateHostedConnectionRequest").add("ConnectionId", (Object)this.connectionId()).add("ParentConnectionId", (Object)this.parentConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "parentConnectionId": {
                return Optional.ofNullable(clazz.cast(this.parentConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String parentConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateHostedConnectionRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.parentConnectionId(model.parentConnectionId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getParentConnectionId() {
            return this.parentConnectionId;
        }

        @Override
        public final Builder parentConnectionId(String parentConnectionId) {
            this.parentConnectionId = parentConnectionId;
            return this;
        }

        public final void setParentConnectionId(String parentConnectionId) {
            this.parentConnectionId = parentConnectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateHostedConnectionRequest build() {
            return new AssociateHostedConnectionRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, AssociateHostedConnectionRequest> {
        public Builder connectionId(String var1);

        public Builder parentConnectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

