/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TagResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceArn").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final TagResourceRequestModelMarshaller INSTANCE = new TagResourceRequestModelMarshaller();

    private TagResourceRequestModelMarshaller() {
    }

    public static TagResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TagResourceRequest tagResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)tagResourceRequest), (String)"tagResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tagResourceRequest.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(tagResourceRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

