/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState;
import software.amazon.awssdk.services.directconnect.transform.DirectConnectGatewayAssociationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAssociation
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectConnectGatewayAssociation> {
    private final String directConnectGatewayId;
    private final String virtualGatewayId;
    private final String virtualGatewayRegion;
    private final String virtualGatewayOwnerAccount;
    private final String associationState;
    private final String stateChangeError;

    private DirectConnectGatewayAssociation(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.virtualGatewayRegion = builder.virtualGatewayRegion;
        this.virtualGatewayOwnerAccount = builder.virtualGatewayOwnerAccount;
        this.associationState = builder.associationState;
        this.stateChangeError = builder.stateChangeError;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public String virtualGatewayRegion() {
        return this.virtualGatewayRegion;
    }

    public String virtualGatewayOwnerAccount() {
        return this.virtualGatewayOwnerAccount;
    }

    public DirectConnectGatewayAssociationState associationState() {
        return DirectConnectGatewayAssociationState.fromValue(this.associationState);
    }

    public String associationStateAsString() {
        return this.associationState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociation)) {
            return false;
        }
        DirectConnectGatewayAssociation other = (DirectConnectGatewayAssociation)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.virtualGatewayRegion(), other.virtualGatewayRegion()) && Objects.equals(this.virtualGatewayOwnerAccount(), other.virtualGatewayOwnerAccount()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGatewayAssociation").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("VirtualGatewayRegion", (Object)this.virtualGatewayRegion()).add("VirtualGatewayOwnerAccount", (Object)this.virtualGatewayOwnerAccount()).add("AssociationState", (Object)this.associationStateAsString()).add("StateChangeError", (Object)this.stateChangeError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
            case "virtualGatewayRegion": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayRegion()));
            }
            case "virtualGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayOwnerAccount()));
            }
            case "associationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "stateChangeError": {
                return Optional.ofNullable(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectConnectGatewayAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualGatewayId;
        private String virtualGatewayRegion;
        private String virtualGatewayOwnerAccount;
        private String associationState;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociation model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualGatewayId(model.virtualGatewayId);
            this.virtualGatewayRegion(model.virtualGatewayRegion);
            this.virtualGatewayOwnerAccount(model.virtualGatewayOwnerAccount);
            this.associationState(model.associationState);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final String getVirtualGatewayRegion() {
            return this.virtualGatewayRegion;
        }

        @Override
        public final Builder virtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
            return this;
        }

        public final void setVirtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
        }

        public final String getVirtualGatewayOwnerAccount() {
            return this.virtualGatewayOwnerAccount;
        }

        @Override
        public final Builder virtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
            return this;
        }

        public final void setVirtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(DirectConnectGatewayAssociationState associationState) {
            this.associationState(associationState.toString());
            return this;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public DirectConnectGatewayAssociation build() {
            return new DirectConnectGatewayAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectConnectGatewayAssociation> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder virtualGatewayRegion(String var1);

        public Builder virtualGatewayOwnerAccount(String var1);

        public Builder associationState(String var1);

        public Builder associationState(DirectConnectGatewayAssociationState var1);

        public Builder stateChangeError(String var1);
    }
}

