/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.Interconnect;
import software.amazon.awssdk.services.directconnect.model.InterconnectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInterconnectsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeInterconnectsResponse> {
    private final List<Interconnect> interconnects;

    private DescribeInterconnectsResponse(BuilderImpl builder) {
        super(builder);
        this.interconnects = builder.interconnects;
    }

    public List<Interconnect> interconnects() {
        return this.interconnects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnects());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectsResponse)) {
            return false;
        }
        DescribeInterconnectsResponse other = (DescribeInterconnectsResponse)((Object)obj);
        return Objects.equals(this.interconnects(), other.interconnects());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInterconnectsResponse").add("Interconnects", this.interconnects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnects": {
                return Optional.ofNullable(clazz.cast(this.interconnects()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Interconnect> interconnects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectsResponse model) {
            super(model);
            this.interconnects(model.interconnects);
        }

        public final Collection<Interconnect.Builder> getInterconnects() {
            return this.interconnects != null ? (Collection)this.interconnects.stream().map(Interconnect::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder interconnects(Collection<Interconnect> interconnects) {
            this.interconnects = InterconnectListCopier.copy(interconnects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interconnects(Interconnect ... interconnects) {
            this.interconnects(Arrays.asList(interconnects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interconnects(Consumer<Interconnect.Builder> ... interconnects) {
            this.interconnects(Stream.of(interconnects).map(c -> (Interconnect)((Interconnect.Builder)Interconnect.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInterconnects(Collection<Interconnect.BuilderImpl> interconnects) {
            this.interconnects = InterconnectListCopier.copyFromBuilder(interconnects);
        }

        @Override
        public DescribeInterconnectsResponse build() {
            return new DescribeInterconnectsResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeInterconnectsResponse> {
        public Builder interconnects(Collection<Interconnect> var1);

        public Builder interconnects(Interconnect ... var1);

        public Builder interconnects(Consumer<Interconnect.Builder> ... var1);
    }
}

