/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.BGPPeer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BGPPeerMarshaller {
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").isBinary(false).build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").isBinary(false).build();
    private static final MarshallingInfo<String> BGPPEERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeerState").isBinary(false).build();
    private static final MarshallingInfo<String> BGPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpStatus").isBinary(false).build();
    private static final BGPPeerMarshaller INSTANCE = new BGPPeerMarshaller();

    private BGPPeerMarshaller() {
    }

    public static BGPPeerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BGPPeer bgpPeer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)bgpPeer, (String)"bgpPeer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)bgpPeer.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.addressFamilyAsString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.bgpPeerStateAsString(), BGPPEERSTATE_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.bgpStatusAsString(), BGPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

