/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState;
import software.amazon.awssdk.services.directconnect.transform.DirectConnectGatewayMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DirectConnectGateway
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectConnectGateway> {
    private final String directConnectGatewayId;
    private final String directConnectGatewayName;
    private final Long amazonSideAsn;
    private final String ownerAccount;
    private final String directConnectGatewayState;
    private final String stateChangeError;

    private DirectConnectGateway(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayName = builder.directConnectGatewayName;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.ownerAccount = builder.ownerAccount;
        this.directConnectGatewayState = builder.directConnectGatewayState;
        this.stateChangeError = builder.stateChangeError;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String directConnectGatewayName() {
        return this.directConnectGatewayName;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public DirectConnectGatewayState directConnectGatewayState() {
        return DirectConnectGatewayState.fromValue(this.directConnectGatewayState);
    }

    public String directConnectGatewayStateAsString() {
        return this.directConnectGatewayState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGateway)) {
            return false;
        }
        DirectConnectGateway other = (DirectConnectGateway)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.directConnectGatewayName(), other.directConnectGatewayName()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.directConnectGatewayStateAsString(), other.directConnectGatewayStateAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGateway").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("DirectConnectGatewayName", (Object)this.directConnectGatewayName()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("OwnerAccount", (Object)this.ownerAccount()).add("DirectConnectGatewayState", (Object)this.directConnectGatewayStateAsString()).add("StateChangeError", (Object)this.stateChangeError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.of(clazz.cast(this.directConnectGatewayId()));
            }
            case "directConnectGatewayName": {
                return Optional.of(clazz.cast(this.directConnectGatewayName()));
            }
            case "amazonSideAsn": {
                return Optional.of(clazz.cast(this.amazonSideAsn()));
            }
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "directConnectGatewayState": {
                return Optional.of(clazz.cast(this.directConnectGatewayStateAsString()));
            }
            case "stateChangeError": {
                return Optional.of(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectConnectGatewayMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String directConnectGatewayName;
        private Long amazonSideAsn;
        private String ownerAccount;
        private String directConnectGatewayState;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGateway model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.directConnectGatewayName(model.directConnectGatewayName);
            this.amazonSideAsn(model.amazonSideAsn);
            this.ownerAccount(model.ownerAccount);
            this.directConnectGatewayState(model.directConnectGatewayState);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayName() {
            return this.directConnectGatewayName;
        }

        @Override
        public final Builder directConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
            return this;
        }

        public final void setDirectConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getDirectConnectGatewayState() {
            return this.directConnectGatewayState;
        }

        @Override
        public final Builder directConnectGatewayState(String directConnectGatewayState) {
            this.directConnectGatewayState = directConnectGatewayState;
            return this;
        }

        @Override
        public final Builder directConnectGatewayState(DirectConnectGatewayState directConnectGatewayState) {
            this.directConnectGatewayState(directConnectGatewayState.toString());
            return this;
        }

        public final void setDirectConnectGatewayState(String directConnectGatewayState) {
            this.directConnectGatewayState = directConnectGatewayState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public DirectConnectGateway build() {
            return new DirectConnectGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectConnectGateway> {
        public Builder directConnectGatewayId(String var1);

        public Builder directConnectGatewayName(String var1);

        public Builder amazonSideAsn(Long var1);

        public Builder ownerAccount(String var1);

        public Builder directConnectGatewayState(String var1);

        public Builder directConnectGatewayState(DirectConnectGatewayState var1);

        public Builder stateChangeError(String var1);
    }
}

