/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePrivateVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreatePrivateVirtualInterfaceRequest> {
    private final String connectionId;
    private final NewPrivateVirtualInterface newPrivateVirtualInterface;

    private CreatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.newPrivateVirtualInterface = builder.newPrivateVirtualInterface;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public NewPrivateVirtualInterface newPrivateVirtualInterface() {
        return this.newPrivateVirtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPrivateVirtualInterface());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        CreatePrivateVirtualInterfaceRequest other = (CreatePrivateVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.newPrivateVirtualInterface(), other.newPrivateVirtualInterface());
    }

    public String toString() {
        return ToString.builder((String)"CreatePrivateVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("NewPrivateVirtualInterface", (Object)this.newPrivateVirtualInterface()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "newPrivateVirtualInterface": {
                return Optional.of(clazz.cast(this.newPrivateVirtualInterface()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private NewPrivateVirtualInterface newPrivateVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.newPrivateVirtualInterface(model.newPrivateVirtualInterface);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final NewPrivateVirtualInterface.Builder getNewPrivateVirtualInterface() {
            return this.newPrivateVirtualInterface != null ? this.newPrivateVirtualInterface.toBuilder() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterface(NewPrivateVirtualInterface newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface;
            return this;
        }

        public final void setNewPrivateVirtualInterface(NewPrivateVirtualInterface.BuilderImpl newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface != null ? newPrivateVirtualInterface.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateVirtualInterfaceRequest build() {
            return new CreatePrivateVirtualInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreatePrivateVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder newPrivateVirtualInterface(NewPrivateVirtualInterface var1);

        default public Builder newPrivateVirtualInterface(Consumer<NewPrivateVirtualInterface.Builder> newPrivateVirtualInterface) {
            return this.newPrivateVirtualInterface((NewPrivateVirtualInterface)((NewPrivateVirtualInterface.Builder)NewPrivateVirtualInterface.builder().apply(newPrivateVirtualInterface)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

