/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.directconnect.model.Location;
import software.amazon.awssdk.services.directconnect.model.LocationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLocationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLocationsResponse> {
    private final List<Location> locations;

    private DescribeLocationsResponse(BuilderImpl builder) {
        this.locations = builder.locations;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.locations() == null ? 0 : this.locations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationsResponse)) {
            return false;
        }
        DescribeLocationsResponse other = (DescribeLocationsResponse)((Object)obj);
        if (other.locations() == null ^ this.locations() == null) {
            return false;
        }
        return other.locations() == null || other.locations().equals(this.locations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.locations() != null) {
            sb.append("Locations: ").append(this.locations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Location> locations = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationsResponse model) {
            this.setLocations(model.locations);
        }

        public final Collection<Location> getLocations() {
            return this.locations;
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location ... locations) {
            if (this.locations == null) {
                this.locations = new SdkInternalList(locations.length);
            }
            for (Location e : locations) {
                this.locations.add(e);
            }
            return this;
        }

        public final void setLocations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
        }

        @SafeVarargs
        public final void setLocations(Location ... locations) {
            if (this.locations == null) {
                this.locations = new SdkInternalList(locations.length);
            }
            for (Location e : locations) {
                this.locations.add(e);
            }
        }

        public DescribeLocationsResponse build() {
            return new DescribeLocationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLocationsResponse> {
        public Builder locations(Collection<Location> var1);

        public Builder locations(Location ... var1);
    }
}

