/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateConnectionOnInterconnectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AllocateConnectionOnInterconnectRequest> {
    private final String bandwidth;
    private final String connectionName;
    private final String ownerAccount;
    private final String interconnectId;
    private final Integer vlan;

    private AllocateConnectionOnInterconnectRequest(BuilderImpl builder) {
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.ownerAccount = builder.ownerAccount;
        this.interconnectId = builder.interconnectId;
        this.vlan = builder.vlan;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bandwidth() == null ? 0 : this.bandwidth().hashCode());
        hashCode = 31 * hashCode + (this.connectionName() == null ? 0 : this.connectionName().hashCode());
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.interconnectId() == null ? 0 : this.interconnectId().hashCode());
        hashCode = 31 * hashCode + (this.vlan() == null ? 0 : this.vlan().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateConnectionOnInterconnectRequest)) {
            return false;
        }
        AllocateConnectionOnInterconnectRequest other = (AllocateConnectionOnInterconnectRequest)((Object)obj);
        if (other.bandwidth() == null ^ this.bandwidth() == null) {
            return false;
        }
        if (other.bandwidth() != null && !other.bandwidth().equals(this.bandwidth())) {
            return false;
        }
        if (other.connectionName() == null ^ this.connectionName() == null) {
            return false;
        }
        if (other.connectionName() != null && !other.connectionName().equals(this.connectionName())) {
            return false;
        }
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.interconnectId() == null ^ this.interconnectId() == null) {
            return false;
        }
        if (other.interconnectId() != null && !other.interconnectId().equals(this.interconnectId())) {
            return false;
        }
        if (other.vlan() == null ^ this.vlan() == null) {
            return false;
        }
        return other.vlan() == null || other.vlan().equals(this.vlan());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bandwidth() != null) {
            sb.append("Bandwidth: ").append(this.bandwidth()).append(",");
        }
        if (this.connectionName() != null) {
            sb.append("ConnectionName: ").append(this.connectionName()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.interconnectId() != null) {
            sb.append("InterconnectId: ").append(this.interconnectId()).append(",");
        }
        if (this.vlan() != null) {
            sb.append("Vlan: ").append(this.vlan()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bandwidth;
        private String connectionName;
        private String ownerAccount;
        private String interconnectId;
        private Integer vlan;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateConnectionOnInterconnectRequest model) {
            this.setBandwidth(model.bandwidth);
            this.setConnectionName(model.connectionName);
            this.setOwnerAccount(model.ownerAccount);
            this.setInterconnectId(model.interconnectId);
            this.setVlan(model.vlan);
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public AllocateConnectionOnInterconnectRequest build() {
            return new AllocateConnectionOnInterconnectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AllocateConnectionOnInterconnectRequest> {
        public Builder bandwidth(String var1);

        public Builder connectionName(String var1);

        public Builder ownerAccount(String var1);

        public Builder interconnectId(String var1);

        public Builder vlan(Integer var1);
    }
}

