/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.ResourcePermission;
import software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter;
import software.amazon.awssdk.services.devopsguru.model.ResourceTypeFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoredResourcesFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListMonitoredResourcesFilters> {
    private static final SdkField<String> RESOURCE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePermission").getter(ListMonitoredResourcesFilters.getter(ListMonitoredResourcesFilters::resourcePermissionAsString)).setter(ListMonitoredResourcesFilters.setter(Builder::resourcePermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePermission").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeFilters").getter(ListMonitoredResourcesFilters.getter(ListMonitoredResourcesFilters::resourceTypeFiltersAsStrings)).setter(ListMonitoredResourcesFilters.setter(Builder::resourceTypeFiltersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_PERMISSION_FIELD, RESOURCE_TYPE_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMonitoredResourcesFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourcePermission;
    private final List<String> resourceTypeFilters;

    private ListMonitoredResourcesFilters(BuilderImpl builder) {
        this.resourcePermission = builder.resourcePermission;
        this.resourceTypeFilters = builder.resourceTypeFilters;
    }

    public final ResourcePermission resourcePermission() {
        return ResourcePermission.fromValue(this.resourcePermission);
    }

    public final String resourcePermissionAsString() {
        return this.resourcePermission;
    }

    public final List<ResourceTypeFilter> resourceTypeFilters() {
        return ResourceTypeFiltersCopier.copyStringToEnum(this.resourceTypeFilters);
    }

    public final boolean hasResourceTypeFilters() {
        return this.resourceTypeFilters != null && !(this.resourceTypeFilters instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypeFiltersAsStrings() {
        return this.resourceTypeFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeFilters() ? this.resourceTypeFiltersAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoredResourcesFilters)) {
            return false;
        }
        ListMonitoredResourcesFilters other = (ListMonitoredResourcesFilters)obj;
        return Objects.equals(this.resourcePermissionAsString(), other.resourcePermissionAsString()) && this.hasResourceTypeFilters() == other.hasResourceTypeFilters() && Objects.equals(this.resourceTypeFiltersAsStrings(), other.resourceTypeFiltersAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitoredResourcesFilters").add("ResourcePermission", (Object)this.resourcePermissionAsString()).add("ResourceTypeFilters", this.hasResourceTypeFilters() ? this.resourceTypeFiltersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourcePermission": {
                return Optional.ofNullable(clazz.cast(this.resourcePermissionAsString()));
            }
            case "ResourceTypeFilters": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeFiltersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourcePermission", RESOURCE_PERMISSION_FIELD);
        map.put("ResourceTypeFilters", RESOURCE_TYPE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoredResourcesFilters, T> g) {
        return obj -> g.apply((ListMonitoredResourcesFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourcePermission;
        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoredResourcesFilters model) {
            this.resourcePermission(model.resourcePermission);
            this.resourceTypeFiltersWithStrings(model.resourceTypeFilters);
        }

        public final String getResourcePermission() {
            return this.resourcePermission;
        }

        public final void setResourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
        }

        @Override
        public final Builder resourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
            return this;
        }

        @Override
        public final Builder resourcePermission(ResourcePermission resourcePermission) {
            this.resourcePermission(resourcePermission == null ? null : resourcePermission.toString());
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (this.resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFiltersWithStrings(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFiltersWithStrings(String ... resourceTypeFilters) {
            this.resourceTypeFiltersWithStrings(Arrays.asList(resourceTypeFilters));
            return this;
        }

        @Override
        public final Builder resourceTypeFilters(Collection<ResourceTypeFilter> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFiltersCopier.copyEnumToString(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(ResourceTypeFilter ... resourceTypeFilters) {
            this.resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        public ListMonitoredResourcesFilters build() {
            return new ListMonitoredResourcesFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListMonitoredResourcesFilters> {
        public Builder resourcePermission(String var1);

        public Builder resourcePermission(ResourcePermission var1);

        public Builder resourceTypeFiltersWithStrings(Collection<String> var1);

        public Builder resourceTypeFiltersWithStrings(String ... var1);

        public Builder resourceTypeFilters(Collection<ResourceTypeFilter> var1);

        public Builder resourceTypeFilters(ResourceTypeFilter ... var1);
    }
}

