/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse;

public class SearchOrganizationInsightsPublisher
implements SdkPublisher<SearchOrganizationInsightsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final SearchOrganizationInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchOrganizationInsightsPublisher(DevOpsGuruAsyncClient client, SearchOrganizationInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchOrganizationInsightsPublisher(DevOpsGuruAsyncClient client, SearchOrganizationInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchOrganizationInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchOrganizationInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProactiveInsightSummary> proactiveInsights() {
        Function<SearchOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchOrganizationInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ReactiveInsightSummary> reactiveInsights() {
        Function<SearchOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchOrganizationInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchOrganizationInsightsResponseFetcher
    implements AsyncPageFetcher<SearchOrganizationInsightsResponse> {
        private SearchOrganizationInsightsResponseFetcher() {
        }

        public boolean hasNextPage(SearchOrganizationInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchOrganizationInsightsResponse> nextPage(SearchOrganizationInsightsResponse previousPage) {
            if (previousPage == null) {
                return SearchOrganizationInsightsPublisher.this.client.searchOrganizationInsights(SearchOrganizationInsightsPublisher.this.firstRequest);
            }
            return SearchOrganizationInsightsPublisher.this.client.searchOrganizationInsights((SearchOrganizationInsightsRequest)((Object)SearchOrganizationInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

