/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the estimated monthly cost to analyze an Amazon Web Services resource. For
 * more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
 * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
 * pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceResourceCost implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceResourceCost.Builder, ServiceResourceCost> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ServiceResourceCost::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ServiceResourceCost::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(ServiceResourceCost::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Double> UNIT_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UnitCost").getter(getter(ServiceResourceCost::unitCost)).setter(setter(Builder::unitCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitCost").build()).build();

    private static final SdkField<Double> COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Cost")
            .getter(getter(ServiceResourceCost::cost)).setter(setter(Builder::cost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATE_FIELD,
            COUNT_FIELD, UNIT_COST_FIELD, COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String state;

    private final Integer count;

    private final Double unitCost;

    private final Double cost;

    private ServiceResourceCost(BuilderImpl builder) {
        this.type = builder.type;
        this.state = builder.state;
        this.count = builder.count;
        this.unitCost = builder.unitCost;
        this.cost = builder.cost;
    }

    /**
     * <p>
     * The type of the Amazon Web Services resource.
     * </p>
     * 
     * @return The type of the Amazon Web Services resource.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an
     * hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours
     * analyzed for each resource. Inactive resources are not charged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CostEstimationServiceResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs
     *         within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web
     *         Services resource hours analyzed for each resource. Inactive resources are not charged.
     * @see CostEstimationServiceResourceState
     */
    public final CostEstimationServiceResourceState state() {
        return CostEstimationServiceResourceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an
     * hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours
     * analyzed for each resource. Inactive resources are not charged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CostEstimationServiceResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs
     *         within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web
     *         Services resource hours analyzed for each resource. Inactive resources are not charged.
     * @see CostEstimationServiceResourceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The number of active resources analyzed for this service to create a monthly cost estimate.
     * </p>
     * 
     * @return The number of active resources analyzed for this service to create a monthly cost estimate.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The price per hour to analyze the resources in the service. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps
     * Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.
     * </p>
     * 
     * @return The price per hour to analyze the resources in the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon
     *         DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     *         pricing</a>.
     */
    public final Double unitCost() {
        return unitCost;
    }

    /**
     * <p>
     * The total estimated monthly cost to analyze the active resources for this resource.
     * </p>
     * 
     * @return The total estimated monthly cost to analyze the active resources for this resource.
     */
    public final Double cost() {
        return cost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(unitCost());
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceResourceCost)) {
            return false;
        }
        ServiceResourceCost other = (ServiceResourceCost) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(count(), other.count()) && Objects.equals(unitCost(), other.unitCost())
                && Objects.equals(cost(), other.cost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceResourceCost").add("Type", type()).add("State", stateAsString()).add("Count", count())
                .add("UnitCost", unitCost()).add("Cost", cost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "UnitCost":
            return Optional.ofNullable(clazz.cast(unitCost()));
        case "Cost":
            return Optional.ofNullable(clazz.cast(cost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceResourceCost, T> g) {
        return obj -> g.apply((ServiceResourceCost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceResourceCost> {
        /**
         * <p>
         * The type of the Amazon Web Services resource.
         * </p>
         * 
         * @param type
         *        The type of the Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within
         * an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource
         * hours analyzed for each resource. Inactive resources are not charged.
         * </p>
         * 
         * @param state
         *        The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs
         *        within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web
         *        Services resource hours analyzed for each resource. Inactive resources are not charged.
         * @see CostEstimationServiceResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostEstimationServiceResourceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within
         * an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource
         * hours analyzed for each resource. Inactive resources are not charged.
         * </p>
         * 
         * @param state
         *        The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs
         *        within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web
         *        Services resource hours analyzed for each resource. Inactive resources are not charged.
         * @see CostEstimationServiceResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostEstimationServiceResourceState
         */
        Builder state(CostEstimationServiceResourceState state);

        /**
         * <p>
         * The number of active resources analyzed for this service to create a monthly cost estimate.
         * </p>
         * 
         * @param count
         *        The number of active resources analyzed for this service to create a monthly cost estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The price per hour to analyze the resources in the service. For more information, see <a
         * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon
         * DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
         * pricing</a>.
         * </p>
         * 
         * @param unitCost
         *        The price per hour to analyze the resources in the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
         *        Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps
         *        Guru pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unitCost(Double unitCost);

        /**
         * <p>
         * The total estimated monthly cost to analyze the active resources for this resource.
         * </p>
         * 
         * @param cost
         *        The total estimated monthly cost to analyze the active resources for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Double cost);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String state;

        private Integer count;

        private Double unitCost;

        private Double cost;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceResourceCost model) {
            type(model.type);
            state(model.state);
            count(model.count);
            unitCost(model.unitCost);
            cost(model.cost);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CostEstimationServiceResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Double getUnitCost() {
            return unitCost;
        }

        public final void setUnitCost(Double unitCost) {
            this.unitCost = unitCost;
        }

        @Override
        public final Builder unitCost(Double unitCost) {
            this.unitCost = unitCost;
            return this;
        }

        public final Double getCost() {
            return cost;
        }

        public final void setCost(Double cost) {
            this.cost = cost;
        }

        @Override
        public final Builder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        @Override
        public ServiceResourceCost build() {
            return new ServiceResourceCost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
