/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ResourceTypeFilter {
    LOG_GROUPS("LOG_GROUPS"),

    CLOUDFRONT_DISTRIBUTION("CLOUDFRONT_DISTRIBUTION"),

    DYNAMODB_TABLE("DYNAMODB_TABLE"),

    EC2_NAT_GATEWAY("EC2_NAT_GATEWAY"),

    ECS_CLUSTER("ECS_CLUSTER"),

    ECS_SERVICE("ECS_SERVICE"),

    EKS_CLUSTER("EKS_CLUSTER"),

    ELASTIC_BEANSTALK_ENVIRONMENT("ELASTIC_BEANSTALK_ENVIRONMENT"),

    ELASTIC_LOAD_BALANCER_LOAD_BALANCER("ELASTIC_LOAD_BALANCER_LOAD_BALANCER"),

    ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER"),

    ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP("ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP"),

    ELASTICACHE_CACHE_CLUSTER("ELASTICACHE_CACHE_CLUSTER"),

    ELASTICSEARCH_DOMAIN("ELASTICSEARCH_DOMAIN"),

    KINESIS_STREAM("KINESIS_STREAM"),

    LAMBDA_FUNCTION("LAMBDA_FUNCTION"),

    OPEN_SEARCH_SERVICE_DOMAIN("OPEN_SEARCH_SERVICE_DOMAIN"),

    RDS_DB_INSTANCE("RDS_DB_INSTANCE"),

    RDS_DB_CLUSTER("RDS_DB_CLUSTER"),

    REDSHIFT_CLUSTER("REDSHIFT_CLUSTER"),

    ROUTE53_HOSTED_ZONE("ROUTE53_HOSTED_ZONE"),

    ROUTE53_HEALTH_CHECK("ROUTE53_HEALTH_CHECK"),

    S3_BUCKET("S3_BUCKET"),

    SAGEMAKER_ENDPOINT("SAGEMAKER_ENDPOINT"),

    SNS_TOPIC("SNS_TOPIC"),

    SQS_QUEUE("SQS_QUEUE"),

    STEP_FUNCTIONS_ACTIVITY("STEP_FUNCTIONS_ACTIVITY"),

    STEP_FUNCTIONS_STATE_MACHINE("STEP_FUNCTIONS_STATE_MACHINE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeFilter> VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeFilter.class,
            ResourceTypeFilter::toString);

    private final String value;

    private ResourceTypeFilter(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ResourceTypeFilter corresponding to the value
     */
    public static ResourceTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ResourceTypeFilter}s
     */
    public static Set<ResourceTypeFilter> knownValues() {
        Set<ResourceTypeFilter> knownValues = EnumSet.allOf(ResourceTypeFilter.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
