/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an
 * insight. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
 * to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS
 * in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for Amazon
 * SNS topics</a>.
 * </p>
 * <p>
 * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed
 * key (CMK), then you must add permissions to the CMK. For more information, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web
 * Services KMS–encrypted Amazon SNS topics</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationChannel implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationChannel.Builder, NotificationChannel> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(NotificationChannel::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<NotificationChannelConfig> CONFIG_FIELD = SdkField
            .<NotificationChannelConfig> builder(MarshallingType.SDK_POJO).memberName("Config")
            .getter(getter(NotificationChannel::config)).setter(setter(Builder::config))
            .constructor(NotificationChannelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final NotificationChannelConfig config;

    private NotificationChannel(BuilderImpl builder) {
        this.id = builder.id;
        this.config = builder.config;
    }

    /**
     * <p>
     * The ID of a notification channel.
     * </p>
     * 
     * @return The ID of a notification channel.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A <code>NotificationChannelConfig</code> object that contains information about configured notification channels.
     * </p>
     * 
     * @return A <code>NotificationChannelConfig</code> object that contains information about configured notification
     *         channels.
     */
    public final NotificationChannelConfig config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationChannel)) {
            return false;
        }
        NotificationChannel other = (NotificationChannel) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationChannel").add("Id", id()).add("Config", config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationChannel, T> g) {
        return obj -> g.apply((NotificationChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationChannel> {
        /**
         * <p>
         * The ID of a notification channel.
         * </p>
         * 
         * @param id
         *        The ID of a notification channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A <code>NotificationChannelConfig</code> object that contains information about configured notification
         * channels.
         * </p>
         * 
         * @param config
         *        A <code>NotificationChannelConfig</code> object that contains information about configured
         *        notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(NotificationChannelConfig config);

        /**
         * <p>
         * A <code>NotificationChannelConfig</code> object that contains information about configured notification
         * channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationChannelConfig.Builder}
         * avoiding the need to create one manually via {@link NotificationChannelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationChannelConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #config(NotificationChannelConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link NotificationChannelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(NotificationChannelConfig)
         */
        default Builder config(Consumer<NotificationChannelConfig.Builder> config) {
            return config(NotificationChannelConfig.builder().applyMutation(config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private NotificationChannelConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationChannel model) {
            id(model.id);
            config(model.config);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final NotificationChannelConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(NotificationChannelConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(NotificationChannelConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public NotificationChannel build() {
            return new NotificationChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
