/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceCollectionResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<GetResourceCollectionResponse.Builder, GetResourceCollectionResponse> {
    private static final SdkField<ResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollectionFilter> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(GetResourceCollectionResponse::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourceCollectionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_FIELD,
            NEXT_TOKEN_FIELD));

    private final ResourceCollectionFilter resourceCollection;

    private final String nextToken;

    private GetResourceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.resourceCollection = builder.resourceCollection;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services resource
     * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
     * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
     * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to
     * 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * 
     * @return The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services
     *         resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services
     *         resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     *         Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag
     *         <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public final ResourceCollectionFilter resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceCollectionResponse)) {
            return false;
        }
        GetResourceCollectionResponse other = (GetResourceCollectionResponse) obj;
        return Objects.equals(resourceCollection(), other.resourceCollection()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceCollectionResponse").add("ResourceCollection", resourceCollection())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceCollectionResponse, T> g) {
        return obj -> g.apply((GetResourceCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceCollectionResponse> {
        /**
         * <p>
         * The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services resource
         * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
         * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
         * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up
         * to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * 
         * @param resourceCollection
         *        The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services
         *        resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services
         *        resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
         *        Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag
         *        <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollectionFilter resourceCollection);

        /**
         * <p>
         * The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services resource
         * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
         * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
         * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up
         * to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCollectionFilter.Builder}
         * avoiding the need to create one manually via {@link ResourceCollectionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollectionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceCollection(ResourceCollectionFilter)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollectionFilter)
         */
        default Builder resourceCollection(Consumer<ResourceCollectionFilter.Builder> resourceCollection) {
            return resourceCollection(ResourceCollectionFilter.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private ResourceCollectionFilter resourceCollection;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceCollectionResponse model) {
            super(model);
            resourceCollection(model.resourceCollection);
            nextToken(model.nextToken);
        }

        public final ResourceCollectionFilter.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceCollectionResponse build() {
            return new GetResourceCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
