/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time range that specifies when DevOps Guru opens and then closes an anomaly. This is different from
 * <code>AnomalyTimeRange</code>, which specifies the time range when DevOps Guru actually observes the anomalous
 * behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyReportedTimeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyReportedTimeRange.Builder, AnomalyReportedTimeRange> {
    private static final SdkField<Instant> OPEN_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OpenTime").getter(getter(AnomalyReportedTimeRange::openTime)).setter(setter(Builder::openTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenTime").build()).build();

    private static final SdkField<Instant> CLOSE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CloseTime").getter(getter(AnomalyReportedTimeRange::closeTime)).setter(setter(Builder::closeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloseTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_TIME_FIELD,
            CLOSE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant openTime;

    private final Instant closeTime;

    private AnomalyReportedTimeRange(BuilderImpl builder) {
        this.openTime = builder.openTime;
        this.closeTime = builder.closeTime;
    }

    /**
     * <p>
     * The time when an anomaly is opened.
     * </p>
     * 
     * @return The time when an anomaly is opened.
     */
    public final Instant openTime() {
        return openTime;
    }

    /**
     * <p>
     * The time when an anomaly is closed.
     * </p>
     * 
     * @return The time when an anomaly is closed.
     */
    public final Instant closeTime() {
        return closeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openTime());
        hashCode = 31 * hashCode + Objects.hashCode(closeTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyReportedTimeRange)) {
            return false;
        }
        AnomalyReportedTimeRange other = (AnomalyReportedTimeRange) obj;
        return Objects.equals(openTime(), other.openTime()) && Objects.equals(closeTime(), other.closeTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyReportedTimeRange").add("OpenTime", openTime()).add("CloseTime", closeTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenTime":
            return Optional.ofNullable(clazz.cast(openTime()));
        case "CloseTime":
            return Optional.ofNullable(clazz.cast(closeTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyReportedTimeRange, T> g) {
        return obj -> g.apply((AnomalyReportedTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyReportedTimeRange> {
        /**
         * <p>
         * The time when an anomaly is opened.
         * </p>
         * 
         * @param openTime
         *        The time when an anomaly is opened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openTime(Instant openTime);

        /**
         * <p>
         * The time when an anomaly is closed.
         * </p>
         * 
         * @param closeTime
         *        The time when an anomaly is closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeTime(Instant closeTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant openTime;

        private Instant closeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyReportedTimeRange model) {
            openTime(model.openTime);
            closeTime(model.closeTime);
        }

        public final Instant getOpenTime() {
            return openTime;
        }

        public final void setOpenTime(Instant openTime) {
            this.openTime = openTime;
        }

        @Override
        public final Builder openTime(Instant openTime) {
            this.openTime = openTime;
            return this;
        }

        public final Instant getCloseTime() {
            return closeTime;
        }

        public final void setCloseTime(Instant closeTime) {
            this.closeTime = closeTime;
        }

        @Override
        public final Builder closeTime(Instant closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        @Override
        public AnomalyReportedTimeRange build() {
            return new AnomalyReportedTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
