/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon CloudWatch log group that contains log anomalies and is used to generate an insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalousLogGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalousLogGroup.Builder, AnomalousLogGroup> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(AnomalousLogGroup::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<Instant> IMPACT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImpactStartTime").getter(getter(AnomalousLogGroup::impactStartTime))
            .setter(setter(Builder::impactStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactStartTime").build()).build();

    private static final SdkField<Instant> IMPACT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImpactEndTime").getter(getter(AnomalousLogGroup::impactEndTime)).setter(setter(Builder::impactEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactEndTime").build()).build();

    private static final SdkField<Integer> NUMBER_OF_LOG_LINES_SCANNED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NumberOfLogLinesScanned")
            .getter(getter(AnomalousLogGroup::numberOfLogLinesScanned)).setter(setter(Builder::numberOfLogLinesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLogLinesScanned").build())
            .build();

    private static final SdkField<List<LogAnomalyShowcase>> LOG_ANOMALY_SHOWCASES_FIELD = SdkField
            .<List<LogAnomalyShowcase>> builder(MarshallingType.LIST)
            .memberName("LogAnomalyShowcases")
            .getter(getter(AnomalousLogGroup::logAnomalyShowcases))
            .setter(setter(Builder::logAnomalyShowcases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyShowcases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogAnomalyShowcase> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogAnomalyShowcase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            IMPACT_START_TIME_FIELD, IMPACT_END_TIME_FIELD, NUMBER_OF_LOG_LINES_SCANNED_FIELD, LOG_ANOMALY_SHOWCASES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final Instant impactStartTime;

    private final Instant impactEndTime;

    private final Integer numberOfLogLinesScanned;

    private final List<LogAnomalyShowcase> logAnomalyShowcases;

    private AnomalousLogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.impactStartTime = builder.impactStartTime;
        this.impactEndTime = builder.impactEndTime;
        this.numberOfLogLinesScanned = builder.numberOfLogLinesScanned;
        this.logAnomalyShowcases = builder.logAnomalyShowcases;
    }

    /**
     * <p>
     * The name of the CloudWatch log group.
     * </p>
     * 
     * @return The name of the CloudWatch log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The time the anomalous log events began. The impact start time indicates the time of the first log anomaly event
     * that occurs.
     * </p>
     * 
     * @return The time the anomalous log events began. The impact start time indicates the time of the first log
     *         anomaly event that occurs.
     */
    public final Instant impactStartTime() {
        return impactStartTime;
    }

    /**
     * <p>
     * The time the anomalous log events stopped.
     * </p>
     * 
     * @return The time the anomalous log events stopped.
     */
    public final Instant impactEndTime() {
        return impactEndTime;
    }

    /**
     * <p>
     * The number of log lines that were scanned for anomalous log events.
     * </p>
     * 
     * @return The number of log lines that were scanned for anomalous log events.
     */
    public final Integer numberOfLogLinesScanned() {
        return numberOfLogLinesScanned;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogAnomalyShowcases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogAnomalyShowcases() {
        return logAnomalyShowcases != null && !(logAnomalyShowcases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log
     * events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogAnomalyShowcases} method.
     * </p>
     * 
     * @return The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous
     *         log events.
     */
    public final List<LogAnomalyShowcase> logAnomalyShowcases() {
        return logAnomalyShowcases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(impactStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(impactEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLogLinesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogAnomalyShowcases() ? logAnomalyShowcases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalousLogGroup)) {
            return false;
        }
        AnomalousLogGroup other = (AnomalousLogGroup) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(impactStartTime(), other.impactStartTime())
                && Objects.equals(impactEndTime(), other.impactEndTime())
                && Objects.equals(numberOfLogLinesScanned(), other.numberOfLogLinesScanned())
                && hasLogAnomalyShowcases() == other.hasLogAnomalyShowcases()
                && Objects.equals(logAnomalyShowcases(), other.logAnomalyShowcases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalousLogGroup").add("LogGroupName", logGroupName())
                .add("ImpactStartTime", impactStartTime()).add("ImpactEndTime", impactEndTime())
                .add("NumberOfLogLinesScanned", numberOfLogLinesScanned())
                .add("LogAnomalyShowcases", hasLogAnomalyShowcases() ? logAnomalyShowcases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "ImpactStartTime":
            return Optional.ofNullable(clazz.cast(impactStartTime()));
        case "ImpactEndTime":
            return Optional.ofNullable(clazz.cast(impactEndTime()));
        case "NumberOfLogLinesScanned":
            return Optional.ofNullable(clazz.cast(numberOfLogLinesScanned()));
        case "LogAnomalyShowcases":
            return Optional.ofNullable(clazz.cast(logAnomalyShowcases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalousLogGroup, T> g) {
        return obj -> g.apply((AnomalousLogGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalousLogGroup> {
        /**
         * <p>
         * The name of the CloudWatch log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the CloudWatch log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The time the anomalous log events began. The impact start time indicates the time of the first log anomaly
         * event that occurs.
         * </p>
         * 
         * @param impactStartTime
         *        The time the anomalous log events began. The impact start time indicates the time of the first log
         *        anomaly event that occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactStartTime(Instant impactStartTime);

        /**
         * <p>
         * The time the anomalous log events stopped.
         * </p>
         * 
         * @param impactEndTime
         *        The time the anomalous log events stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactEndTime(Instant impactEndTime);

        /**
         * <p>
         * The number of log lines that were scanned for anomalous log events.
         * </p>
         * 
         * @param numberOfLogLinesScanned
         *        The number of log lines that were scanned for anomalous log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLogLinesScanned(Integer numberOfLogLinesScanned);

        /**
         * <p>
         * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log
         * events.
         * </p>
         * 
         * @param logAnomalyShowcases
         *        The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar
         *        anomalous log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logAnomalyShowcases(Collection<LogAnomalyShowcase> logAnomalyShowcases);

        /**
         * <p>
         * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log
         * events.
         * </p>
         * 
         * @param logAnomalyShowcases
         *        The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar
         *        anomalous log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logAnomalyShowcases(LogAnomalyShowcase... logAnomalyShowcases);

        /**
         * <p>
         * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log
         * events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase.Builder#build()} is called
         * immediately and its result is passed to {@link #logAnomalyShowcases(List<LogAnomalyShowcase>)}.
         * 
         * @param logAnomalyShowcases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logAnomalyShowcases(java.util.Collection<LogAnomalyShowcase>)
         */
        Builder logAnomalyShowcases(Consumer<LogAnomalyShowcase.Builder>... logAnomalyShowcases);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private Instant impactStartTime;

        private Instant impactEndTime;

        private Integer numberOfLogLinesScanned;

        private List<LogAnomalyShowcase> logAnomalyShowcases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalousLogGroup model) {
            logGroupName(model.logGroupName);
            impactStartTime(model.impactStartTime);
            impactEndTime(model.impactEndTime);
            numberOfLogLinesScanned(model.numberOfLogLinesScanned);
            logAnomalyShowcases(model.logAnomalyShowcases);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getImpactStartTime() {
            return impactStartTime;
        }

        public final void setImpactStartTime(Instant impactStartTime) {
            this.impactStartTime = impactStartTime;
        }

        @Override
        public final Builder impactStartTime(Instant impactStartTime) {
            this.impactStartTime = impactStartTime;
            return this;
        }

        public final Instant getImpactEndTime() {
            return impactEndTime;
        }

        public final void setImpactEndTime(Instant impactEndTime) {
            this.impactEndTime = impactEndTime;
        }

        @Override
        public final Builder impactEndTime(Instant impactEndTime) {
            this.impactEndTime = impactEndTime;
            return this;
        }

        public final Integer getNumberOfLogLinesScanned() {
            return numberOfLogLinesScanned;
        }

        public final void setNumberOfLogLinesScanned(Integer numberOfLogLinesScanned) {
            this.numberOfLogLinesScanned = numberOfLogLinesScanned;
        }

        @Override
        public final Builder numberOfLogLinesScanned(Integer numberOfLogLinesScanned) {
            this.numberOfLogLinesScanned = numberOfLogLinesScanned;
            return this;
        }

        public final List<LogAnomalyShowcase.Builder> getLogAnomalyShowcases() {
            List<LogAnomalyShowcase.Builder> result = LogAnomalyShowcasesCopier.copyToBuilder(this.logAnomalyShowcases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogAnomalyShowcases(Collection<LogAnomalyShowcase.BuilderImpl> logAnomalyShowcases) {
            this.logAnomalyShowcases = LogAnomalyShowcasesCopier.copyFromBuilder(logAnomalyShowcases);
        }

        @Override
        public final Builder logAnomalyShowcases(Collection<LogAnomalyShowcase> logAnomalyShowcases) {
            this.logAnomalyShowcases = LogAnomalyShowcasesCopier.copy(logAnomalyShowcases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyShowcases(LogAnomalyShowcase... logAnomalyShowcases) {
            logAnomalyShowcases(Arrays.asList(logAnomalyShowcases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyShowcases(Consumer<LogAnomalyShowcase.Builder>... logAnomalyShowcases) {
            logAnomalyShowcases(Stream.of(logAnomalyShowcases).map(c -> LogAnomalyShowcase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnomalousLogGroup build() {
            return new AnomalousLogGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
