/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter;

public class GetResourceCollectionPublisher
implements SdkPublisher<GetResourceCollectionResponse> {
    private final DevOpsGuruAsyncClient client;
    private final GetResourceCollectionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceCollectionPublisher(DevOpsGuruAsyncClient client, GetResourceCollectionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceCollectionPublisher(DevOpsGuruAsyncClient client, GetResourceCollectionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceCollectionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceCollectionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> stackNames() {
        Function<GetResourceCollectionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCollection() != null && response.resourceCollection().cloudFormation() != null && response.resourceCollection().cloudFormation().stackNames() != null) {
                return response.resourceCollection().cloudFormation().stackNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourceCollectionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<TagCollectionFilter> tags() {
        Function<GetResourceCollectionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCollection() != null && response.resourceCollection().tags() != null) {
                return response.resourceCollection().tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourceCollectionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourceCollectionResponseFetcher
    implements AsyncPageFetcher<GetResourceCollectionResponse> {
        private GetResourceCollectionResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceCollectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceCollectionResponse> nextPage(GetResourceCollectionResponse previousPage) {
            if (previousPage == null) {
                return GetResourceCollectionPublisher.this.client.getResourceCollection(GetResourceCollectionPublisher.this.firstRequest);
            }
            return GetResourceCollectionPublisher.this.client.getResourceCollection((GetResourceCollectionRequest)((Object)GetResourceCollectionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

