/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse;

public class SearchOrganizationInsightsIterable
implements SdkIterable<SearchOrganizationInsightsResponse> {
    private final DevOpsGuruClient client;
    private final SearchOrganizationInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchOrganizationInsightsIterable(DevOpsGuruClient client, SearchOrganizationInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchOrganizationInsightsResponseFetcher();
    }

    public Iterator<SearchOrganizationInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProactiveInsightSummary> proactiveInsights() {
        Function<SearchOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ReactiveInsightSummary> reactiveInsights() {
        Function<SearchOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchOrganizationInsightsResponseFetcher
    implements SyncPageFetcher<SearchOrganizationInsightsResponse> {
        private SearchOrganizationInsightsResponseFetcher() {
        }

        public boolean hasNextPage(SearchOrganizationInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchOrganizationInsightsResponse nextPage(SearchOrganizationInsightsResponse previousPage) {
            if (previousPage == null) {
                return SearchOrganizationInsightsIterable.this.client.searchOrganizationInsights(SearchOrganizationInsightsIterable.this.firstRequest);
            }
            return SearchOrganizationInsightsIterable.this.client.searchOrganizationInsights((SearchOrganizationInsightsRequest)((Object)SearchOrganizationInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

