/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealth;
import software.amazon.awssdk.services.devopsguru.model.TagHealth;

public class DescribeResourceCollectionHealthIterable
implements SdkIterable<DescribeResourceCollectionHealthResponse> {
    private final DevOpsGuruClient client;
    private final DescribeResourceCollectionHealthRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeResourceCollectionHealthIterable(DevOpsGuruClient client, DescribeResourceCollectionHealthRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeResourceCollectionHealthResponseFetcher();
    }

    public Iterator<DescribeResourceCollectionHealthResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudFormationHealth> cloudFormation() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFormation() != null) {
                return response.cloudFormation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ServiceHealth> service() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.service() != null) {
                return response.service().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<TagHealth> tags() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeResourceCollectionHealthResponseFetcher
    implements SyncPageFetcher<DescribeResourceCollectionHealthResponse> {
        private DescribeResourceCollectionHealthResponseFetcher() {
        }

        public boolean hasNextPage(DescribeResourceCollectionHealthResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeResourceCollectionHealthResponse nextPage(DescribeResourceCollectionHealthResponse previousPage) {
            if (previousPage == null) {
                return DescribeResourceCollectionHealthIterable.this.client.describeResourceCollectionHealth(DescribeResourceCollectionHealthIterable.this.firstRequest);
            }
            return DescribeResourceCollectionHealthIterable.this.client.describeResourceCollectionHealth((DescribeResourceCollectionHealthRequest)((Object)DescribeResourceCollectionHealthIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

