/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AssociatedResourceArnsCopier;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.InsightStatus;
import software.amazon.awssdk.services.devopsguru.model.InsightTimeRange;
import software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.services.devopsguru.model.ServiceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProactiveInsightSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProactiveInsightSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::id)).setter(ProactiveInsightSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::name)).setter(ProactiveInsightSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::severityAsString)).setter(ProactiveInsightSummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::statusAsString)).setter(ProactiveInsightSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsightTimeRange").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::insightTimeRange)).setter(ProactiveInsightSummary.setter(Builder::insightTimeRange)).constructor(InsightTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()}).build();
    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictionTimeRange").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::predictionTimeRange)).setter(ProactiveInsightSummary.setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::resourceCollection)).setter(ProactiveInsightSummary.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCollection").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::serviceCollection)).setter(ProactiveInsightSummary.setter(Builder::serviceCollection)).constructor(ServiceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResourceArns").getter(ProactiveInsightSummary.getter(ProactiveInsightSummary::associatedResourceArns)).setter(ProactiveInsightSummary.setter(Builder::associatedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, SEVERITY_FIELD, STATUS_FIELD, INSIGHT_TIME_RANGE_FIELD, PREDICTION_TIME_RANGE_FIELD, RESOURCE_COLLECTION_FIELD, SERVICE_COLLECTION_FIELD, ASSOCIATED_RESOURCE_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String severity;
    private final String status;
    private final InsightTimeRange insightTimeRange;
    private final PredictionTimeRange predictionTimeRange;
    private final ResourceCollection resourceCollection;
    private final ServiceCollection serviceCollection;
    private final List<String> associatedResourceArns;

    private ProactiveInsightSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.severity = builder.severity;
        this.status = builder.status;
        this.insightTimeRange = builder.insightTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.resourceCollection = builder.resourceCollection;
        this.serviceCollection = builder.serviceCollection;
        this.associatedResourceArns = builder.associatedResourceArns;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final InsightSeverity severity() {
        return InsightSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final InsightStatus status() {
        return InsightStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InsightTimeRange insightTimeRange() {
        return this.insightTimeRange;
    }

    public final PredictionTimeRange predictionTimeRange() {
        return this.predictionTimeRange;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public final ServiceCollection serviceCollection() {
        return this.serviceCollection;
    }

    public final boolean hasAssociatedResourceArns() {
        return this.associatedResourceArns != null && !(this.associatedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceArns() {
        return this.associatedResourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceArns() ? this.associatedResourceArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveInsightSummary)) {
            return false;
        }
        ProactiveInsightSummary other = (ProactiveInsightSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.insightTimeRange(), other.insightTimeRange()) && Objects.equals(this.predictionTimeRange(), other.predictionTimeRange()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.serviceCollection(), other.serviceCollection()) && this.hasAssociatedResourceArns() == other.hasAssociatedResourceArns() && Objects.equals(this.associatedResourceArns(), other.associatedResourceArns());
    }

    public final String toString() {
        return ToString.builder((String)"ProactiveInsightSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("InsightTimeRange", (Object)this.insightTimeRange()).add("PredictionTimeRange", (Object)this.predictionTimeRange()).add("ResourceCollection", (Object)this.resourceCollection()).add("ServiceCollection", (Object)this.serviceCollection()).add("AssociatedResourceArns", this.hasAssociatedResourceArns() ? this.associatedResourceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InsightTimeRange": {
                return Optional.ofNullable(clazz.cast(this.insightTimeRange()));
            }
            case "PredictionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.predictionTimeRange()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "ServiceCollection": {
                return Optional.ofNullable(clazz.cast(this.serviceCollection()));
            }
            case "AssociatedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProactiveInsightSummary, T> g) {
        return obj -> g.apply((ProactiveInsightSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String severity;
        private String status;
        private InsightTimeRange insightTimeRange;
        private PredictionTimeRange predictionTimeRange;
        private ResourceCollection resourceCollection;
        private ServiceCollection serviceCollection;
        private List<String> associatedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveInsightSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.severity(model.severity);
            this.status(model.status);
            this.insightTimeRange(model.insightTimeRange);
            this.predictionTimeRange(model.predictionTimeRange);
            this.resourceCollection(model.resourceCollection);
            this.serviceCollection(model.serviceCollection);
            this.associatedResourceArns(model.associatedResourceArns);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        @Transient
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return this.insightTimeRange != null ? this.insightTimeRange.toBuilder() : null;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        @Override
        @Transient
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return this.predictionTimeRange != null ? this.predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        @Transient
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return this.serviceCollection != null ? this.serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        public final Collection<String> getAssociatedResourceArns() {
            if (this.associatedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceArns;
        }

        public final void setAssociatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = AssociatedResourceArnsCopier.copy(associatedResourceArns);
        }

        @Override
        @Transient
        public final Builder associatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = AssociatedResourceArnsCopier.copy(associatedResourceArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associatedResourceArns(String ... associatedResourceArns) {
            this.associatedResourceArns(Arrays.asList(associatedResourceArns));
            return this;
        }

        public ProactiveInsightSummary build() {
            return new ProactiveInsightSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProactiveInsightSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder severity(String var1);

        public Builder severity(InsightSeverity var1);

        public Builder status(String var1);

        public Builder status(InsightStatus var1);

        public Builder insightTimeRange(InsightTimeRange var1);

        default public Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return this.insightTimeRange((InsightTimeRange)((InsightTimeRange.Builder)InsightTimeRange.builder().applyMutation(insightTimeRange)).build());
        }

        public Builder predictionTimeRange(PredictionTimeRange var1);

        default public Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return this.predictionTimeRange((PredictionTimeRange)((PredictionTimeRange.Builder)PredictionTimeRange.builder().applyMutation(predictionTimeRange)).build());
        }

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder serviceCollection(ServiceCollection var1);

        default public Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return this.serviceCollection((ServiceCollection)((ServiceCollection.Builder)ServiceCollection.builder().applyMutation(serviceCollection)).build());
        }

        public Builder associatedResourceArns(Collection<String> var1);

        public Builder associatedResourceArns(String ... var1);
    }
}

