/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.InsightHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationHealth> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(CloudFormationHealth.getter(CloudFormationHealth::stackName)).setter(CloudFormationHealth.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<InsightHealth> INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Insight").getter(CloudFormationHealth.getter(CloudFormationHealth::insight)).setter(CloudFormationHealth.setter(Builder::insight)).constructor(InsightHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, INSIGHT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackName;
    private final InsightHealth insight;

    private CloudFormationHealth(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.insight = builder.insight;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final InsightHealth insight() {
        return this.insight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.insight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationHealth)) {
            return false;
        }
        CloudFormationHealth other = (CloudFormationHealth)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.insight(), other.insight());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationHealth").add("StackName", (Object)this.stackName()).add("Insight", (Object)this.insight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "Insight": {
                return Optional.ofNullable(clazz.cast(this.insight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationHealth, T> g) {
        return obj -> g.apply((CloudFormationHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private InsightHealth insight;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationHealth model) {
            this.stackName(model.stackName);
            this.insight(model.insight);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final InsightHealth.Builder getInsight() {
            return this.insight != null ? this.insight.toBuilder() : null;
        }

        public final void setInsight(InsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        @Transient
        public final Builder insight(InsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public CloudFormationHealth build() {
            return new CloudFormationHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationHealth> {
        public Builder stackName(String var1);

        public Builder insight(InsightHealth var1);

        default public Builder insight(Consumer<InsightHealth.Builder> insight) {
            return this.insight((InsightHealth)((InsightHealth.Builder)InsightHealth.builder().applyMutation(insight)).build());
        }
    }
}

