/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange;
import software.amazon.awssdk.services.devopsguru.model.AnomalySeverity;
import software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails;
import software.amazon.awssdk.services.devopsguru.model.AnomalyStatus;
import software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReactiveAnomalySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReactiveAnomalySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::id)).setter(ReactiveAnomalySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::severityAsString)).setter(ReactiveAnomalySummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::statusAsString)).setter(ReactiveAnomalySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyTimeRange").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::anomalyTimeRange)).setter(ReactiveAnomalySummary.setter(Builder::anomalyTimeRange)).constructor(AnomalyTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()}).build();
    private static final SdkField<AnomalyReportedTimeRange> ANOMALY_REPORTED_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyReportedTimeRange").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::anomalyReportedTimeRange)).setter(ReactiveAnomalySummary.setter(Builder::anomalyReportedTimeRange)).constructor(AnomalyReportedTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyReportedTimeRange").build()}).build();
    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDetails").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::sourceDetails)).setter(ReactiveAnomalySummary.setter(Builder::sourceDetails)).constructor(AnomalySourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()}).build();
    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedInsightId").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::associatedInsightId)).setter(ReactiveAnomalySummary.setter(Builder::associatedInsightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ReactiveAnomalySummary.getter(ReactiveAnomalySummary::resourceCollection)).setter(ReactiveAnomalySummary.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, ANOMALY_TIME_RANGE_FIELD, ANOMALY_REPORTED_TIME_RANGE_FIELD, SOURCE_DETAILS_FIELD, ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String severity;
    private final String status;
    private final AnomalyTimeRange anomalyTimeRange;
    private final AnomalyReportedTimeRange anomalyReportedTimeRange;
    private final AnomalySourceDetails sourceDetails;
    private final String associatedInsightId;
    private final ResourceCollection resourceCollection;

    private ReactiveAnomalySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.anomalyReportedTimeRange = builder.anomalyReportedTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
    }

    public final String id() {
        return this.id;
    }

    public final AnomalySeverity severity() {
        return AnomalySeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final AnomalyStatus status() {
        return AnomalyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AnomalyTimeRange anomalyTimeRange() {
        return this.anomalyTimeRange;
    }

    public final AnomalyReportedTimeRange anomalyReportedTimeRange() {
        return this.anomalyReportedTimeRange;
    }

    public final AnomalySourceDetails sourceDetails() {
        return this.sourceDetails;
    }

    public final String associatedInsightId() {
        return this.associatedInsightId;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyReportedTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveAnomalySummary)) {
            return false;
        }
        ReactiveAnomalySummary other = (ReactiveAnomalySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.anomalyTimeRange(), other.anomalyTimeRange()) && Objects.equals(this.anomalyReportedTimeRange(), other.anomalyReportedTimeRange()) && Objects.equals(this.sourceDetails(), other.sourceDetails()) && Objects.equals(this.associatedInsightId(), other.associatedInsightId()) && Objects.equals(this.resourceCollection(), other.resourceCollection());
    }

    public final String toString() {
        return ToString.builder((String)"ReactiveAnomalySummary").add("Id", (Object)this.id()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("AnomalyTimeRange", (Object)this.anomalyTimeRange()).add("AnomalyReportedTimeRange", (Object)this.anomalyReportedTimeRange()).add("SourceDetails", (Object)this.sourceDetails()).add("AssociatedInsightId", (Object)this.associatedInsightId()).add("ResourceCollection", (Object)this.resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AnomalyTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyTimeRange()));
            }
            case "AnomalyReportedTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyReportedTimeRange()));
            }
            case "SourceDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceDetails()));
            }
            case "AssociatedInsightId": {
                return Optional.ofNullable(clazz.cast(this.associatedInsightId()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactiveAnomalySummary, T> g) {
        return obj -> g.apply((ReactiveAnomalySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String severity;
        private String status;
        private AnomalyTimeRange anomalyTimeRange;
        private AnomalyReportedTimeRange anomalyReportedTimeRange;
        private AnomalySourceDetails sourceDetails;
        private String associatedInsightId;
        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveAnomalySummary model) {
            this.id(model.id);
            this.severity(model.severity);
            this.status(model.status);
            this.anomalyTimeRange(model.anomalyTimeRange);
            this.anomalyReportedTimeRange(model.anomalyReportedTimeRange);
            this.sourceDetails(model.sourceDetails);
            this.associatedInsightId(model.associatedInsightId);
            this.resourceCollection(model.resourceCollection);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return this.anomalyTimeRange != null ? this.anomalyTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        public final AnomalyReportedTimeRange.Builder getAnomalyReportedTimeRange() {
            return this.anomalyReportedTimeRange != null ? this.anomalyReportedTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder anomalyReportedTimeRange(AnomalyReportedTimeRange anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange;
            return this;
        }

        public final void setAnomalyReportedTimeRange(AnomalyReportedTimeRange.BuilderImpl anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange != null ? anomalyReportedTimeRange.build() : null;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return this.sourceDetails != null ? this.sourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        public final String getAssociatedInsightId() {
            return this.associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public ReactiveAnomalySummary build() {
            return new ReactiveAnomalySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReactiveAnomalySummary> {
        public Builder id(String var1);

        public Builder severity(String var1);

        public Builder severity(AnomalySeverity var1);

        public Builder status(String var1);

        public Builder status(AnomalyStatus var1);

        public Builder anomalyTimeRange(AnomalyTimeRange var1);

        default public Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return this.anomalyTimeRange((AnomalyTimeRange)((AnomalyTimeRange.Builder)AnomalyTimeRange.builder().applyMutation(anomalyTimeRange)).build());
        }

        public Builder anomalyReportedTimeRange(AnomalyReportedTimeRange var1);

        default public Builder anomalyReportedTimeRange(Consumer<AnomalyReportedTimeRange.Builder> anomalyReportedTimeRange) {
            return this.anomalyReportedTimeRange((AnomalyReportedTimeRange)((AnomalyReportedTimeRange.Builder)AnomalyReportedTimeRange.builder().applyMutation(anomalyReportedTimeRange)).build());
        }

        public Builder sourceDetails(AnomalySourceDetails var1);

        default public Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return this.sourceDetails((AnomalySourceDetails)((AnomalySourceDetails.Builder)AnomalySourceDetails.builder().applyMutation(sourceDetails)).build());
        }

        public Builder associatedInsightId(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }
    }
}

