/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.ServiceName;
import software.amazon.awssdk.services.devopsguru.model.ServiceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceCollection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceCollection> {
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceNames").getter(ServiceCollection.getter(ServiceCollection::serviceNamesAsStrings)).setter(ServiceCollection.setter(Builder::serviceNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> serviceNames;

    private ServiceCollection(BuilderImpl builder) {
        this.serviceNames = builder.serviceNames;
    }

    public final List<ServiceName> serviceNames() {
        return ServiceNamesCopier.copyStringToEnum(this.serviceNames);
    }

    public final boolean hasServiceNames() {
        return this.serviceNames != null && !(this.serviceNames instanceof SdkAutoConstructList);
    }

    public final List<String> serviceNamesAsStrings() {
        return this.serviceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceNames() ? this.serviceNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCollection)) {
            return false;
        }
        ServiceCollection other = (ServiceCollection)obj;
        return this.hasServiceNames() == other.hasServiceNames() && Objects.equals(this.serviceNamesAsStrings(), other.serviceNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceCollection").add("ServiceNames", this.hasServiceNames() ? this.serviceNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNames": {
                return Optional.ofNullable(clazz.cast(this.serviceNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCollection, T> g) {
        return obj -> g.apply((ServiceCollection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCollection model) {
            this.serviceNamesWithStrings(model.serviceNames);
        }

        public final Collection<String> getServiceNames() {
            if (this.serviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceNames;
        }

        @Override
        public final Builder serviceNamesWithStrings(Collection<String> serviceNames) {
            this.serviceNames = ServiceNamesCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNamesWithStrings(String ... serviceNames) {
            this.serviceNamesWithStrings(Arrays.asList(serviceNames));
            return this;
        }

        @Override
        public final Builder serviceNames(Collection<ServiceName> serviceNames) {
            this.serviceNames = ServiceNamesCopier.copyEnumToString(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(ServiceName ... serviceNames) {
            this.serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ServiceNamesCopier.copy(serviceNames);
        }

        public ServiceCollection build() {
            return new ServiceCollection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceCollection> {
        public Builder serviceNamesWithStrings(Collection<String> var1);

        public Builder serviceNamesWithStrings(String ... var1);

        public Builder serviceNames(Collection<ServiceName> var1);

        public Builder serviceNames(ServiceName ... var1);
    }
}

