/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the integration of DevOps Guru with another AWS service, such as AWS Systems Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceIntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceIntegrationConfig.Builder, ServiceIntegrationConfig> {
    private static final SdkField<OpsCenterIntegration> OPS_CENTER_FIELD = SdkField
            .<OpsCenterIntegration> builder(MarshallingType.SDK_POJO).memberName("OpsCenter")
            .getter(getter(ServiceIntegrationConfig::opsCenter)).setter(setter(Builder::opsCenter))
            .constructor(OpsCenterIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_CENTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final OpsCenterIntegration opsCenter;

    private ServiceIntegrationConfig(BuilderImpl builder) {
        this.opsCenter = builder.opsCenter;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for
     * each created insight.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter
     *         for each created insight.
     */
    public final OpsCenterIntegration opsCenter() {
        return opsCenter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsCenter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationConfig)) {
            return false;
        }
        ServiceIntegrationConfig other = (ServiceIntegrationConfig) obj;
        return Objects.equals(opsCenter(), other.opsCenter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceIntegrationConfig").add("OpsCenter", opsCenter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsCenter":
            return Optional.ofNullable(clazz.cast(opsCenter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationConfig, T> g) {
        return obj -> g.apply((ServiceIntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceIntegrationConfig> {
        /**
         * <p>
         * Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for
         * each created insight.
         * </p>
         * 
         * @param opsCenter
         *        Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager
         *        OpsCenter for each created insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenter(OpsCenterIntegration opsCenter);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for
         * each created insight.
         * </p>
         * This is a convenience that creates an instance of the {@link OpsCenterIntegration.Builder} avoiding the need
         * to create one manually via {@link OpsCenterIntegration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpsCenterIntegration.Builder#build()} is called immediately and
         * its result is passed to {@link #opsCenter(OpsCenterIntegration)}.
         * 
         * @param opsCenter
         *        a consumer that will call methods on {@link OpsCenterIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsCenter(OpsCenterIntegration)
         */
        default Builder opsCenter(Consumer<OpsCenterIntegration.Builder> opsCenter) {
            return opsCenter(OpsCenterIntegration.builder().applyMutation(opsCenter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpsCenterIntegration opsCenter;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationConfig model) {
            opsCenter(model.opsCenter);
        }

        public final OpsCenterIntegration.Builder getOpsCenter() {
            return opsCenter != null ? opsCenter.toBuilder() : null;
        }

        @Override
        public final Builder opsCenter(OpsCenterIntegration opsCenter) {
            this.opsCenter = opsCenter;
            return this;
        }

        public final void setOpsCenter(OpsCenterIntegration.BuilderImpl opsCenter) {
            this.opsCenter = opsCenter != null ? opsCenter.build() : null;
        }

        @Override
        public ServiceIntegrationConfig build() {
            return new ServiceIntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
