/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS
 * CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the
 * stacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCollection implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCollection.Builder, ResourceCollection> {
    private static final SdkField<CloudFormationCollection> CLOUD_FORMATION_FIELD = SdkField
            .<CloudFormationCollection> builder(MarshallingType.SDK_POJO).memberName("CloudFormation")
            .getter(getter(ResourceCollection::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(CloudFormationCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudFormationCollection cloudFormation;

    private ResourceCollection(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
    }

    /**
     * <p>
     * An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru analyzes.
     * </p>
     * 
     * @return An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru
     *         analyzes.
     */
    public final CloudFormationCollection cloudFormation() {
        return cloudFormation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollection)) {
            return false;
        }
        ResourceCollection other = (ResourceCollection) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCollection").add("CloudFormation", cloudFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCollection, T> g) {
        return obj -> g.apply((ResourceCollection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCollection> {
        /**
         * <p>
         * An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru
         * analyzes.
         * </p>
         * 
         * @param cloudFormation
         *        An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru
         *        analyzes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationCollection cloudFormation);

        /**
         * <p>
         * An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru
         * analyzes.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFormationCollection.Builder} avoiding the
         * need to create one manually via {@link CloudFormationCollection#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFormationCollection.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFormation(CloudFormationCollection)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link CloudFormationCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(CloudFormationCollection)
         */
        default Builder cloudFormation(Consumer<CloudFormationCollection.Builder> cloudFormation) {
            return cloudFormation(CloudFormationCollection.builder().applyMutation(cloudFormation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationCollection cloudFormation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCollection model) {
            cloudFormation(model.cloudFormation);
        }

        public final CloudFormationCollection.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        @Override
        public final Builder cloudFormation(CloudFormationCollection cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final void setCloudFormation(CloudFormationCollection.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public ResourceCollection build() {
            return new ResourceCollection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
