/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru. It is one of many analyzed metrics
 * that are used to generate insights.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationRelatedCloudWatchMetricsSourceDetail
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RecommendationRelatedCloudWatchMetricsSourceDetail.Builder, RecommendationRelatedCloudWatchMetricsSourceDetail> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(RecommendationRelatedCloudWatchMetricsSourceDetail::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RecommendationRelatedCloudWatchMetricsSourceDetail::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            NAMESPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String namespace;

    private RecommendationRelatedCloudWatchMetricsSourceDetail(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The name of the CloudWatch metric.
     * </p>
     * 
     * @return The name of the CloudWatch metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
     * </p>
     * 
     * @return The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationRelatedCloudWatchMetricsSourceDetail)) {
            return false;
        }
        RecommendationRelatedCloudWatchMetricsSourceDetail other = (RecommendationRelatedCloudWatchMetricsSourceDetail) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationRelatedCloudWatchMetricsSourceDetail").add("MetricName", metricName())
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationRelatedCloudWatchMetricsSourceDetail, T> g) {
        return obj -> g.apply((RecommendationRelatedCloudWatchMetricsSourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationRelatedCloudWatchMetricsSourceDetail> {
        /**
         * <p>
         * The name of the CloudWatch metric.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
         * </p>
         * 
         * @param namespace
         *        The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationRelatedCloudWatchMetricsSourceDetail model) {
            metricName(model.metricName);
            namespace(model.namespace);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public RecommendationRelatedCloudWatchMetricsSourceDetail build() {
            return new RecommendationRelatedCloudWatchMetricsSourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
