/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time range during which an AWS event occurred. AWS resource events and metrics are analyzed by DevOps Guru to
 * find anomalous behavior and provide recommendations to improve your operational solutions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTimeRange implements SdkPojo, Serializable, ToCopyableBuilder<EventTimeRange.Builder, EventTimeRange> {
    private static final SdkField<Instant> FROM_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromTime").getter(getter(EventTimeRange::fromTime)).setter(setter(Builder::fromTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTime").build()).build();

    private static final SdkField<Instant> TO_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToTime").getter(getter(EventTimeRange::toTime)).setter(setter(Builder::toTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FROM_TIME_FIELD, TO_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant fromTime;

    private final Instant toTime;

    private EventTimeRange(BuilderImpl builder) {
        this.fromTime = builder.fromTime;
        this.toTime = builder.toTime;
    }

    /**
     * <p>
     * The time when the event started.
     * </p>
     * 
     * @return The time when the event started.
     */
    public final Instant fromTime() {
        return fromTime;
    }

    /**
     * <p>
     * The time when the event ended.
     * </p>
     * 
     * @return The time when the event ended.
     */
    public final Instant toTime() {
        return toTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromTime());
        hashCode = 31 * hashCode + Objects.hashCode(toTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTimeRange)) {
            return false;
        }
        EventTimeRange other = (EventTimeRange) obj;
        return Objects.equals(fromTime(), other.fromTime()) && Objects.equals(toTime(), other.toTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTimeRange").add("FromTime", fromTime()).add("ToTime", toTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromTime":
            return Optional.ofNullable(clazz.cast(fromTime()));
        case "ToTime":
            return Optional.ofNullable(clazz.cast(toTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventTimeRange, T> g) {
        return obj -> g.apply((EventTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTimeRange> {
        /**
         * <p>
         * The time when the event started.
         * </p>
         * 
         * @param fromTime
         *        The time when the event started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromTime(Instant fromTime);

        /**
         * <p>
         * The time when the event ended.
         * </p>
         * 
         * @param toTime
         *        The time when the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toTime(Instant toTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant fromTime;

        private Instant toTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTimeRange model) {
            fromTime(model.fromTime);
            toTime(model.toTime);
        }

        public final Instant getFromTime() {
            return fromTime;
        }

        @Override
        public final Builder fromTime(Instant fromTime) {
            this.fromTime = fromTime;
            return this;
        }

        public final void setFromTime(Instant fromTime) {
            this.fromTime = fromTime;
        }

        public final Instant getToTime() {
            return toTime;
        }

        @Override
        public final Builder toTime(Instant toTime) {
            this.toTime = toTime;
            return this;
        }

        public final void setToTime(Instant toTime) {
            this.toTime = toTime;
        }

        @Override
        public EventTimeRange build() {
            return new EventTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
