/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountOverviewResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeAccountOverviewResponse.Builder, DescribeAccountOverviewResponse> {
    private static final SdkField<Integer> REACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReactiveInsights").getter(getter(DescribeAccountOverviewResponse::reactiveInsights))
            .setter(setter(Builder::reactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build()).build();

    private static final SdkField<Integer> PROACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProactiveInsights").getter(getter(DescribeAccountOverviewResponse::proactiveInsights))
            .setter(setter(Builder::proactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build()).build();

    private static final SdkField<Long> MEAN_TIME_TO_RECOVER_IN_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MeanTimeToRecoverInMilliseconds")
            .getter(getter(DescribeAccountOverviewResponse::meanTimeToRecoverInMilliseconds))
            .setter(setter(Builder::meanTimeToRecoverInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeanTimeToRecoverInMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTIVE_INSIGHTS_FIELD,
            PROACTIVE_INSIGHTS_FIELD, MEAN_TIME_TO_RECOVER_IN_MILLISECONDS_FIELD));

    private final Integer reactiveInsights;

    private final Integer proactiveInsights;

    private final Long meanTimeToRecoverInMilliseconds;

    private DescribeAccountOverviewResponse(BuilderImpl builder) {
        super(builder);
        this.reactiveInsights = builder.reactiveInsights;
        this.proactiveInsights = builder.proactiveInsights;
        this.meanTimeToRecoverInMilliseconds = builder.meanTimeToRecoverInMilliseconds;
    }

    /**
     * <p>
     * An integer that specifies the number of open reactive insights in your AWS account that were created during the
     * time range passed in.
     * </p>
     * 
     * @return An integer that specifies the number of open reactive insights in your AWS account that were created
     *         during the time range passed in.
     */
    public final Integer reactiveInsights() {
        return reactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open proactive insights in your AWS account that were created during the
     * time range passed in.
     * </p>
     * 
     * @return An integer that specifies the number of open proactive insights in your AWS account that were created
     *         during the time range passed in.
     */
    public final Integer proactiveInsights() {
        return proactiveInsights;
    }

    /**
     * <p>
     * The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed in.
     * </p>
     * 
     * @return The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed
     *         in.
     */
    public final Long meanTimeToRecoverInMilliseconds() {
        return meanTimeToRecoverInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(proactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(meanTimeToRecoverInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountOverviewResponse)) {
            return false;
        }
        DescribeAccountOverviewResponse other = (DescribeAccountOverviewResponse) obj;
        return Objects.equals(reactiveInsights(), other.reactiveInsights())
                && Objects.equals(proactiveInsights(), other.proactiveInsights())
                && Objects.equals(meanTimeToRecoverInMilliseconds(), other.meanTimeToRecoverInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountOverviewResponse").add("ReactiveInsights", reactiveInsights())
                .add("ProactiveInsights", proactiveInsights())
                .add("MeanTimeToRecoverInMilliseconds", meanTimeToRecoverInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReactiveInsights":
            return Optional.ofNullable(clazz.cast(reactiveInsights()));
        case "ProactiveInsights":
            return Optional.ofNullable(clazz.cast(proactiveInsights()));
        case "MeanTimeToRecoverInMilliseconds":
            return Optional.ofNullable(clazz.cast(meanTimeToRecoverInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountOverviewResponse, T> g) {
        return obj -> g.apply((DescribeAccountOverviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountOverviewResponse> {
        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your AWS account that were created during
         * the time range passed in.
         * </p>
         * 
         * @param reactiveInsights
         *        An integer that specifies the number of open reactive insights in your AWS account that were created
         *        during the time range passed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(Integer reactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your AWS account that were created during
         * the time range passed in.
         * </p>
         * 
         * @param proactiveInsights
         *        An integer that specifies the number of open proactive insights in your AWS account that were created
         *        during the time range passed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(Integer proactiveInsights);

        /**
         * <p>
         * The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed in.
         * </p>
         * 
         * @param meanTimeToRecoverInMilliseconds
         *        The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private Integer reactiveInsights;

        private Integer proactiveInsights;

        private Long meanTimeToRecoverInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountOverviewResponse model) {
            super(model);
            reactiveInsights(model.reactiveInsights);
            proactiveInsights(model.proactiveInsights);
            meanTimeToRecoverInMilliseconds(model.meanTimeToRecoverInMilliseconds);
        }

        public final Integer getReactiveInsights() {
            return reactiveInsights;
        }

        @Override
        public final Builder reactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
            return this;
        }

        public final void setReactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
        }

        public final Integer getProactiveInsights() {
            return proactiveInsights;
        }

        @Override
        public final Builder proactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
            return this;
        }

        public final void setProactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
        }

        public final Long getMeanTimeToRecoverInMilliseconds() {
            return meanTimeToRecoverInMilliseconds;
        }

        @Override
        public final Builder meanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds) {
            this.meanTimeToRecoverInMilliseconds = meanTimeToRecoverInMilliseconds;
            return this;
        }

        public final void setMeanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds) {
            this.meanTimeToRecoverInMilliseconds = meanTimeToRecoverInMilliseconds;
        }

        @Override
        public DescribeAccountOverviewResponse build() {
            return new DescribeAccountOverviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
