/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountHealthResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeAccountHealthResponse.Builder, DescribeAccountHealthResponse> {
    private static final SdkField<Integer> OPEN_REACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenReactiveInsights").getter(getter(DescribeAccountHealthResponse::openReactiveInsights))
            .setter(setter(Builder::openReactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenReactiveInsights").build())
            .build();

    private static final SdkField<Integer> OPEN_PROACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenProactiveInsights").getter(getter(DescribeAccountHealthResponse::openProactiveInsights))
            .setter(setter(Builder::openProactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenProactiveInsights").build())
            .build();

    private static final SdkField<Integer> METRICS_ANALYZED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MetricsAnalyzed").getter(getter(DescribeAccountHealthResponse::metricsAnalyzed))
            .setter(setter(Builder::metricsAnalyzed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsAnalyzed").build()).build();

    private static final SdkField<Long> RESOURCE_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResourceHours").getter(getter(DescribeAccountHealthResponse::resourceHours))
            .setter(setter(Builder::resourceHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_REACTIVE_INSIGHTS_FIELD,
            OPEN_PROACTIVE_INSIGHTS_FIELD, METRICS_ANALYZED_FIELD, RESOURCE_HOURS_FIELD));

    private final Integer openReactiveInsights;

    private final Integer openProactiveInsights;

    private final Integer metricsAnalyzed;

    private final Long resourceHours;

    private DescribeAccountHealthResponse(BuilderImpl builder) {
        super(builder);
        this.openReactiveInsights = builder.openReactiveInsights;
        this.openProactiveInsights = builder.openProactiveInsights;
        this.metricsAnalyzed = builder.metricsAnalyzed;
        this.resourceHours = builder.resourceHours;
    }

    /**
     * <p>
     * An integer that specifies the number of open reactive insights in your AWS account.
     * </p>
     * 
     * @return An integer that specifies the number of open reactive insights in your AWS account.
     */
    public final Integer openReactiveInsights() {
        return openReactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open proactive insights in your AWS account.
     * </p>
     * 
     * @return An integer that specifies the number of open proactive insights in your AWS account.
     */
    public final Integer openProactiveInsights() {
        return openProactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of metrics that have been analyzed in your AWS account.
     * </p>
     * 
     * @return An integer that specifies the number of metrics that have been analyzed in your AWS account.
     */
    public final Integer metricsAnalyzed() {
        return metricsAnalyzed;
    }

    /**
     * <p>
     * The number of Amazon DevOps Guru resource analysis hours billed to the current AWS account in the last hour.
     * </p>
     * 
     * @return The number of Amazon DevOps Guru resource analysis hours billed to the current AWS account in the last
     *         hour.
     */
    public final Long resourceHours() {
        return resourceHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(openReactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(openProactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(metricsAnalyzed());
        hashCode = 31 * hashCode + Objects.hashCode(resourceHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountHealthResponse)) {
            return false;
        }
        DescribeAccountHealthResponse other = (DescribeAccountHealthResponse) obj;
        return Objects.equals(openReactiveInsights(), other.openReactiveInsights())
                && Objects.equals(openProactiveInsights(), other.openProactiveInsights())
                && Objects.equals(metricsAnalyzed(), other.metricsAnalyzed())
                && Objects.equals(resourceHours(), other.resourceHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountHealthResponse").add("OpenReactiveInsights", openReactiveInsights())
                .add("OpenProactiveInsights", openProactiveInsights()).add("MetricsAnalyzed", metricsAnalyzed())
                .add("ResourceHours", resourceHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenReactiveInsights":
            return Optional.ofNullable(clazz.cast(openReactiveInsights()));
        case "OpenProactiveInsights":
            return Optional.ofNullable(clazz.cast(openProactiveInsights()));
        case "MetricsAnalyzed":
            return Optional.ofNullable(clazz.cast(metricsAnalyzed()));
        case "ResourceHours":
            return Optional.ofNullable(clazz.cast(resourceHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountHealthResponse, T> g) {
        return obj -> g.apply((DescribeAccountHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountHealthResponse> {
        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your AWS account.
         * </p>
         * 
         * @param openReactiveInsights
         *        An integer that specifies the number of open reactive insights in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openReactiveInsights(Integer openReactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your AWS account.
         * </p>
         * 
         * @param openProactiveInsights
         *        An integer that specifies the number of open proactive insights in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openProactiveInsights(Integer openProactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of metrics that have been analyzed in your AWS account.
         * </p>
         * 
         * @param metricsAnalyzed
         *        An integer that specifies the number of metrics that have been analyzed in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsAnalyzed(Integer metricsAnalyzed);

        /**
         * <p>
         * The number of Amazon DevOps Guru resource analysis hours billed to the current AWS account in the last hour.
         * </p>
         * 
         * @param resourceHours
         *        The number of Amazon DevOps Guru resource analysis hours billed to the current AWS account in the last
         *        hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceHours(Long resourceHours);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private Integer openReactiveInsights;

        private Integer openProactiveInsights;

        private Integer metricsAnalyzed;

        private Long resourceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountHealthResponse model) {
            super(model);
            openReactiveInsights(model.openReactiveInsights);
            openProactiveInsights(model.openProactiveInsights);
            metricsAnalyzed(model.metricsAnalyzed);
            resourceHours(model.resourceHours);
        }

        public final Integer getOpenReactiveInsights() {
            return openReactiveInsights;
        }

        @Override
        public final Builder openReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
            return this;
        }

        public final void setOpenReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
        }

        public final Integer getOpenProactiveInsights() {
            return openProactiveInsights;
        }

        @Override
        public final Builder openProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
            return this;
        }

        public final void setOpenProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
        }

        public final Integer getMetricsAnalyzed() {
            return metricsAnalyzed;
        }

        @Override
        public final Builder metricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
            return this;
        }

        public final void setMetricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
        }

        public final Long getResourceHours() {
            return resourceHours;
        }

        @Override
        public final Builder resourceHours(Long resourceHours) {
            this.resourceHours = resourceHours;
            return this;
        }

        public final void setResourceHours(Long resourceHours) {
            this.resourceHours = resourceHours;
        }

        @Override
        public DescribeAccountHealthResponse build() {
            return new DescribeAccountHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
