/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the health of AWS resources in your account that are specified by an AWS CloudFormation stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFormationHealth implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFormationHealth.Builder, CloudFormationHealth> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(CloudFormationHealth::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<InsightHealth> INSIGHT_FIELD = SdkField.<InsightHealth> builder(MarshallingType.SDK_POJO)
            .memberName("Insight").getter(getter(CloudFormationHealth::insight)).setter(setter(Builder::insight))
            .constructor(InsightHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            INSIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackName;

    private final InsightHealth insight;

    private CloudFormationHealth(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.insight = builder.insight;
    }

    /**
     * <p>
     * The name of the CloudFormation stack.
     * </p>
     * 
     * @return The name of the CloudFormation stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation
     * stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of
     * closed insights.
     * </p>
     * 
     * @return Information about the health of the AWS resources in your account that are specified by an AWS
     *         CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time
     *         to Recover (MTTR) of closed insights.
     */
    public final InsightHealth insight() {
        return insight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(insight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationHealth)) {
            return false;
        }
        CloudFormationHealth other = (CloudFormationHealth) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(insight(), other.insight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFormationHealth").add("StackName", stackName()).add("Insight", insight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "Insight":
            return Optional.ofNullable(clazz.cast(insight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationHealth, T> g) {
        return obj -> g.apply((CloudFormationHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFormationHealth> {
        /**
         * <p>
         * The name of the CloudFormation stack.
         * </p>
         * 
         * @param stackName
         *        The name of the CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation
         * stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of
         * closed insights.
         * </p>
         * 
         * @param insight
         *        Information about the health of the AWS resources in your account that are specified by an AWS
         *        CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean
         *        Time to Recover (MTTR) of closed insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insight(InsightHealth insight);

        /**
         * <p>
         * Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation
         * stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of
         * closed insights.
         * </p>
         * This is a convenience that creates an instance of the {@link InsightHealth.Builder} avoiding the need to
         * create one manually via {@link InsightHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link InsightHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #insight(InsightHealth)}.
         * 
         * @param insight
         *        a consumer that will call methods on {@link InsightHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insight(InsightHealth)
         */
        default Builder insight(Consumer<InsightHealth.Builder> insight) {
            return insight(InsightHealth.builder().applyMutation(insight).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private InsightHealth insight;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationHealth model) {
            stackName(model.stackName);
            insight(model.insight);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final InsightHealth.Builder getInsight() {
            return insight != null ? insight.toBuilder() : null;
        }

        @Override
        public final Builder insight(InsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public final void setInsight(InsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public CloudFormationHealth build() {
            return new CloudFormationHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
