/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SampleType {
    CPU("CPU"),
    MEMORY("MEMORY"),
    THREADS("THREADS"),
    RX_RATE("RX_RATE"),
    TX_RATE("TX_RATE"),
    RX("RX"),
    TX("TX"),
    NATIVE_FRAMES("NATIVE_FRAMES"),
    NATIVE_FPS("NATIVE_FPS"),
    NATIVE_MIN_DRAWTIME("NATIVE_MIN_DRAWTIME"),
    NATIVE_AVG_DRAWTIME("NATIVE_AVG_DRAWTIME"),
    NATIVE_MAX_DRAWTIME("NATIVE_MAX_DRAWTIME"),
    OPENGL_FRAMES("OPENGL_FRAMES"),
    OPENGL_FPS("OPENGL_FPS"),
    OPENGL_MIN_DRAWTIME("OPENGL_MIN_DRAWTIME"),
    OPENGL_AVG_DRAWTIME("OPENGL_AVG_DRAWTIME"),
    OPENGL_MAX_DRAWTIME("OPENGL_MAX_DRAWTIME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SampleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SampleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SampleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SampleType> knownValues() {
        return Stream.of(SampleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

